/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbp;

@Hide
public final class zzbbo
extends UIController {
    private final ImageView zza;
    private final ImageHints zzb;
    private final Bitmap zzc;
    private final ImagePicker zzd;
    private final zzbax zze;

    public zzbbo(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        CastMediaOptions castMediaOptions;
        this.zza = imageView;
        this.zzb = imageHints;
        this.zzc = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastContext castContext = CastContext.zza(context);
        this.zzd = castContext != null ? ((castMediaOptions = castContext.getCastOptions().getCastMediaOptions()) != null ? castMediaOptions.getImagePicker() : null) : null;
        this.zze = new zzbax(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zze.zza(new zzbbp(this));
        this.zza.setImageBitmap(this.zzc);
        this.zza();
    }

    @Override
    public final void onSessionEnded() {
        this.zze.zza();
        this.zza.setImageBitmap(this.zzc);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zza();
    }

    private final void zza() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zza.setImageBitmap(this.zzc);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzbbo zzbbo2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzbbo2.zzd != null && (webImage = zzbbo2.zzd.onPickImage(mediaInfo.getMetadata(), zzbbo2.zzb)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zza.setImageBitmap(this.zzc);
            return;
        }
        this.zze.zza(uri);
    }

    static /* synthetic */ ImageView zza(zzbbo zzbbo2) {
        return zzbbo2.zza;
    }
}

