/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbr;

@Hide
public final class zzbbq
extends UIController {
    private final ImageView zza;
    private final ImageHints zzb;
    private final Bitmap zzc;
    private final View zzd;
    private final ImagePicker zze;
    private final zzbax zzf;

    public zzbbq(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        CastMediaOptions castMediaOptions;
        this.zza = imageView;
        this.zzb = imageHints;
        this.zzc = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzd = view;
        CastContext castContext = CastContext.zza(context);
        this.zze = castContext != null ? ((castMediaOptions = castContext.getCastOptions().getCastMediaOptions()) != null ? castMediaOptions.getImagePicker() : null) : null;
        this.zzf = new zzbax(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzf.zza(new zzbbr(this));
        this.zzb();
        this.zza();
    }

    @Override
    public final void onSessionEnded() {
        this.zzf.zza();
        this.zzb();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zza();
    }

    private final void zza() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzb();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzbbq zzbbq2 = this;
        if ((mediaInfo == null ? null : (uri = zzbbq2.zze != null && (webImage = zzbbq2.zze.onPickImage(mediaInfo.getMetadata(), zzbbq2.zzb)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzb();
            return;
        }
        this.zzf.zza(uri);
    }

    private final void zzb() {
        if (this.zzd != null) {
            this.zzd.setVisibility(0);
            this.zza.setVisibility(4);
        }
        if (this.zzc != null) {
            this.zza.setImageBitmap(this.zzc);
        }
    }

    static /* synthetic */ View zza(zzbbq zzbbq2) {
        return zzbbq2.zzd;
    }

    static /* synthetic */ ImageView zzb(zzbbq zzbbq2) {
        return zzbbq2.zza;
    }
}

