/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.uicontroller.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.zzc;
import com.google.android.gms.cast.framework.media.uicontroller.zzd;
import com.google.android.gms.cast.framework.media.uicontroller.zze;
import com.google.android.gms.cast.framework.media.uicontroller.zzf;
import com.google.android.gms.cast.framework.media.uicontroller.zzg;
import com.google.android.gms.cast.framework.media.uicontroller.zzh;
import com.google.android.gms.cast.framework.media.uicontroller.zzi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbbn;
import com.google.android.gms.internal.zzbbo;
import com.google.android.gms.internal.zzbbq;
import com.google.android.gms.internal.zzbbs;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbbx;
import com.google.android.gms.internal.zzbby;
import com.google.android.gms.internal.zzbca;
import com.google.android.gms.internal.zzbcb;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcd;
import com.google.android.gms.internal.zzbce;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbcg;
import com.google.android.gms.internal.zzbch;
import com.google.android.gms.internal.zzbci;
import com.google.android.gms.internal.zzbcj;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbei;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private static final zzbei zzeui = new zzbei("UIMediaController");
    private final Activity mActivity;
    private final SessionManager zzezv;
    private final Map<View, List<UIController>> zzfhk = new HashMap<View, List<UIController>>();
    private final Set<zzbci> zzfhl = new HashSet<zzbci>();
    private RemoteMediaClient.Listener zzfhm;
    private RemoteMediaClient zzfaq;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        CastContext castContext = CastContext.zzbu((Context)activity);
        SessionManager sessionManager = this.zzezv = castContext != null ? castContext.getSessionManager() : null;
        if (this.zzezv != null) {
            SessionManager sessionManager2 = CastContext.getSharedInstance((Context)activity).getSessionManager();
            sessionManager2.addSessionManagerListener(this, CastSession.class);
            this.zza(sessionManager2.getCurrentCastSession());
        }
    }

    public boolean isActive() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzfaq != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzfaq;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zzfhm = listener;
    }

    public void dispose() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zzafw();
        this.zzfhk.clear();
        if (this.zzezv != null) {
            this.zzezv.removeSessionManagerListener(this, CastSession.class);
        }
        this.zzfhm = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zza(this));
        this.zza((View)imageView, new zzbca(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzb(this));
        this.zza(view, new zzbce(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzc(this));
        this.zza(view, new zzbcf(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzd(this, l));
        this.zza(view, new zzbcd(view));
    }

    public void bindViewToRewind(View view, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zze(this, l));
        this.zza(view, new zzbcd(view));
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza(view, new zzbbv(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzbcb(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new zzf(this));
        this.zza((View)seekBar, new zzbcc(seekBar, l));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        zzbci zzbci2 = new zzbci(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzfhl.add(zzbci2);
        }
        this.zza((View)textView, zzbci2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbch(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbch(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzg(this));
        this.zza(view, new zzbbs(view));
    }

    public void bindViewToClosedCaption(View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzh(this));
        this.zza(view, new zzbbn(view, (Context)this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zzi(this));
        this.zza((View)imageView, new zzbby(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbbx(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza(view, new zzbck(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbbw(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbo(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbo(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza(view, new zzbcj(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbcg(textView));
    }

    protected void onMuteToggleClicked(ImageView imageView) {
        CastSession castSession = CastContext.getSharedInstance(this.mActivity.getApplicationContext()).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return;
        }
        try {
            boolean bl = castSession.isMute();
            castSession.setMute(!bl);
            return;
        }
        catch (IOException | IllegalArgumentException exception) {
            zzeui.zzc("Unable to call CastSession.setMute(boolean).", new Object[]{exception});
            return;
        }
    }

    protected void onPlayPauseToggleClicked(ImageView imageView) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.togglePlayback();
        }
    }

    protected void onSeekBarStopTrackingTouch(SeekBar seekBar) {
        if (this.zzfhk.containsKey(seekBar)) {
            for (UIController uIController : this.zzfhk.get(seekBar)) {
                if (!(uIController instanceof zzbcc)) continue;
                ((zzbcc)uIController).zzbf(true);
            }
        }
        Object object = this.zzfhl.iterator();
        while (object.hasNext()) {
            ((zzbci)object.next()).zzbf(true);
        }
        object = this.getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            ((RemoteMediaClient)object).seek(seekBar.getProgress());
        }
    }

    protected void onSeekBarStartTrackingTouch(SeekBar seekBar) {
        if (this.zzfhk.containsKey(seekBar)) {
            for (UIController uIController : this.zzfhk.get(seekBar)) {
                if (!(uIController instanceof zzbcc)) continue;
                ((zzbcc)uIController).zzbf(false);
            }
        }
        Iterator<UIController> iterator = this.zzfhl.iterator();
        while (iterator.hasNext()) {
            ((zzbci)iterator.next()).zzbf(false);
        }
    }

    protected void onSeekBarProgressChanged(SeekBar seekBar, int n, boolean bl) {
        if (bl) {
            Iterator<zzbci> iterator = this.zzfhl.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzy(n);
            }
        }
    }

    protected void onClosedCaptionClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (this.mActivity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)this.mActivity;
            FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
            Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
            if (fragment != null) {
                fragmentTransaction.remove(fragment);
            }
            fragmentTransaction.addToBackStack(null);
            MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
            long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
            TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
            if (tracksChooserDialogFragment != null) {
                tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
            }
        }
    }

    protected void onForwardClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() + l);
        }
    }

    protected void onLaunchExpandedControllerClicked(View view) {
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance((Context)this.mActivity).getCastOptions().getCastMediaOptions();
        ComponentName componentName = new ComponentName(this.mActivity.getApplicationContext(), castMediaOptions.getExpandedControllerActivityClassName());
        Intent intent = new Intent();
        intent.setComponent(componentName);
        this.mActivity.startActivity(intent);
    }

    protected void onRewindClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() - l);
        }
    }

    protected void onSkipNextClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queueNext(null);
        }
    }

    protected void onSkipPrevClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queuePrev(null);
        }
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzafw();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzafw();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzafw();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzafx();
        if (this.zzfhm != null) {
            this.zzfhm.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzafx();
        if (this.zzfhm != null) {
            this.zzfhm.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzafx();
        if (this.zzfhm != null) {
            this.zzfhm.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzafx();
        if (this.zzfhm != null) {
            this.zzfhm.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzafx();
        if (this.zzfhm != null) {
            this.zzfhm.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzfhk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzfhm != null) {
            this.zzfhm.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzfaq = castSession.getRemoteMediaClient();
        if (this.zzfaq != null) {
            this.zzfaq.addListener(this);
            Iterator<List<UIController>> iterator = this.zzfhk.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzafx();
        }
    }

    private final void zzafw() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzfhk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzfaq.removeListener(this);
        this.zzfaq = null;
    }

    private final void zza(View view, UIController uIController) {
        if (this.zzezv == null) {
            return;
        }
        List<UIController> list = this.zzfhk.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzfhk.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzezv.getCurrentCastSession());
            this.zzafx();
        }
    }

    private final void zzafx() {
        Iterator<List<UIController>> iterator = this.zzfhk.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }
}

