/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zznw;

public class zznz
implements RemoteMediaClient.Listener {
    private final Context zzbxe;
    private final CastOptions mx;
    private final zznv kh;
    private final ComponentName my;
    private RemoteMediaClient jL;
    private CastDevice gE;
    private MediaSessionCompat mz;
    private MediaSessionCompat.Callback mA;
    private zznw mB;
    private boolean mC;

    public zznz(Context context, CastOptions castOptions, zznv zznv2) {
        this.zzbxe = context;
        this.mx = castOptions;
        this.kh = zznv2;
        this.my = this.mx.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.mx.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzbxe, this.mx.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mC || this.mx == null || this.mx.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.jL = remoteMediaClient;
        this.jL.addListener(this);
        this.gE = castDevice;
        AudioManager audioManager = (AudioManager)this.zzbxe.getSystemService("audio");
        audioManager.requestAudioFocus(null, 3, 3);
        ComponentName componentName = new ComponentName(this.zzbxe, this.mx.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzbxe, (int)0, (Intent)intent, (int)0);
        this.mz = new MediaSessionCompat(this.zzbxe, "CastMediaSession", componentName, pendingIntent);
        this.mz.setFlags(3);
        this.zza(0, null);
        if (this.gE != null && !TextUtils.isEmpty((CharSequence)this.gE.getFriendlyName())) {
            this.mz.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzbxe.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.gE.getFriendlyName()})).build());
        }
        this.mA = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zznz.this.jL.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zznz.this.jL.togglePlayback();
            }

            public void onPause() {
                zznz.this.jL.togglePlayback();
            }
        };
        this.mz.setCallback(this.mA);
        this.mz.setActive(true);
        this.kh.setMediaSessionCompat(this.mz);
        this.mC = true;
        this.zzakw();
    }

    public void zzem(int n) {
        if (!this.mC) {
            return;
        }
        this.mC = false;
        if (this.jL != null) {
            this.jL.removeListener(this);
        }
        AudioManager audioManager = (AudioManager)this.zzbxe.getSystemService("audio");
        audioManager.abandonAudioFocus(null);
        this.kh.setMediaSessionCompat(null);
        if (this.mB != null) {
            this.mB.cancel(true);
            this.mB = null;
        }
        if (this.mz != null) {
            this.mz.setSessionActivity(null);
            this.mz.setCallback(null);
            this.mz.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.mz.setActive(false);
            this.mz.release();
            this.mz = null;
        }
        this.jL = null;
        this.gE = null;
        this.mA = null;
        this.zzakz();
        if (n == 0) {
            this.zzalb();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.mz == null ? null : this.mz.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzakw();
    }

    @Override
    public void onStatusUpdated() {
        this.zzakw();
    }

    @Override
    public void onMetadataUpdated() {
        this.zzakw();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzakw();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zzakw() {
        MediaStatus mediaStatus = this.jL.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        int n = 0;
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.jL.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.jL.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    if (bl) {
                        mediaInfo = mediaStatus.getQueueItemById(n3).getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzakz();
            this.zzalb();
        } else {
            this.zzaky();
            if (!bl) {
                this.zzala();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.mz.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.mz.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.mz.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.mz.setSessionActivity(this.zzalc());
            this.zza(mediaInfo);
        }
    }

    private void zza(MediaInfo mediaInfo) {
        if (this.mB != null) {
            this.mB.cancel(true);
            this.mB = null;
        }
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zzakx().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        Uri uri = this.zzb(mediaMetadata);
        if (uri == null) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.zzbxe.getResources(), (int)(Build.VERSION.SDK_INT > 18 ? R.drawable.cast_album_art_placeholder_large : R.drawable.cast_album_art_placeholder));
            this.mz.setMetadata(zznz.zza(builder, bitmap).build());
        } else {
            this.mz.setMetadata(builder.build());
            this.mB = new zznw(this.zzbxe){

                protected void onPostExecute(Bitmap bitmap) {
                    if (zznz.this.mB == this) {
                        zznz.this.mB = null;
                        if (bitmap != null) {
                            zznz.this.mz.setMetadata(zznz.zza(zznz.this.zzakx(), bitmap).build());
                        }
                    }
                }
            };
            this.mB.zzn(uri);
        }
    }

    private static MediaMetadataCompat.Builder zza(MediaMetadataCompat.Builder builder, Bitmap bitmap) {
        builder.putBitmap("android.media.metadata.ALBUM_ART", bitmap);
        if (Build.VERSION.SDK_INT < 21) {
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            builder.putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2);
        }
        return builder;
    }

    private Uri zzb(MediaMetadata mediaMetadata) {
        WebImage webImage = this.mx.getCastMediaOptions().getImagePicker() != null ? this.mx.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, 0) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zzakx() {
        MediaMetadataCompat mediaMetadataCompat = this.mz.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zzaky() {
        if (this.mx.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.jL == null) {
            return;
        }
        Intent intent = new Intent(this.zzbxe, MediaNotificationService.class);
        intent.setPackage(this.zzbxe.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.jL.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.jL.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.gE);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.jL.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzbxe.startService(intent);
    }

    private void zzakz() {
        if (this.mx.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzbxe, MediaNotificationService.class);
        intent.setPackage(this.zzbxe.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzbxe.stopService(intent);
    }

    private void zzala() {
        if (!this.mx.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbxe, ReconnectionService.class);
        intent.setPackage(this.zzbxe.getPackageName());
        this.zzbxe.startService(intent);
    }

    private void zzalb() {
        if (!this.mx.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbxe, ReconnectionService.class);
        intent.setPackage(this.zzbxe.getPackageName());
        this.zzbxe.stopService(intent);
    }

    private PendingIntent zzalc() {
        if (this.my == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.my);
        return PendingIntent.getActivity((Context)this.zzbxe, (int)0, (Intent)intent, (int)0x8000000);
    }
}

