/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznp;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View jO;
        private int jP;
        private String jQ;
        private OnOverlayDismissedListener jR;
        private boolean jS;
        private float jT;
        private String jU;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzab.zzy((Object)activity);
            if (zzs.zzavn()) {
                this.jO = ((MenuItem)zzab.zzy((Object)menuItem)).getActionView();
            }
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzab.zzy((Object)activity);
            this.jO = (View)zzab.zzy((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.jP = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.jQ = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.jQ = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.jR = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.jS = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.jT = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.jT = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.jU = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.jU = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzaja() {
            return this.jO;
        }

        public OnOverlayDismissedListener zzajb() {
            return this.jR;
        }

        public int zzajc() {
            return this.jP;
        }

        public boolean zzajd() {
            return this.jS;
        }

        public String zzaje() {
            return this.jQ;
        }

        public String zzajf() {
            return this.jU;
        }

        public float zzajg() {
            return this.jT;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzavr()) {
                return new zzno(this);
            }
            return new zznp(this);
        }
    }

    public static class zza {
        public static void zzbe(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbf(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

