/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.RemoteException;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzc;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.framework.zzr;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;

public class SessionManager {
    private static final zzm jo = new zzm("SessionManager");
    private final zzn jZ;

    public SessionManager(zzn zzn2) {
        this.jZ = zzn2;
    }

    public Session getCurrentSession() {
        try {
            return (Session)zze.zzad((zzd)this.jZ.zzaiy());
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzn.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        try {
            this.jZ.zzb(true, bl);
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzn.class.getSimpleName()});
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzab.zzy(sessionManagerListener);
        zzab.zzy(clazz);
        try {
            this.jZ.zza(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzab.zzy((Object)clazz);
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.jZ.zzb(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzab.zzy((Object)castStateListener);
        try {
            this.jZ.zza(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzn.class.getSimpleName()});
        }
    }

    public void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.jZ.zzb(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzn.class.getSimpleName()});
        }
    }

    public zzd zzain() {
        try {
            return this.jZ.zzais();
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzn.class.getSimpleName()});
            return null;
        }
    }
}

