/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzaeq;
import com.google.android.gms.internal.zzaes;

class zzc
extends Drawable {
    private final Paint ko = new Paint();
    private final Paint kO = new Paint();
    private final Rect kt = new Rect();
    private final int kP;
    private final int kQ;
    private float kp;
    private float kR = 1.0f;
    private float centerX;
    private float centerY;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.kP = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.kQ = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.ko.setAntiAlias(true);
        this.ko.setStyle(Paint.Style.FILL);
        this.kO.setAntiAlias(true);
        this.kO.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        float f = 0.0f - 0.0f;
        int cfr_ignored_1 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        canvas.drawCircle(this.centerX, this.centerY, this.kp * this.kR, this.ko);
    }

    public void setAlpha(int n) {
        this.ko.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.ko.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(@ColorInt int n) {
        this.ko.setColor(n);
        this.kO.setColor(n);
        this.invalidateSelf();
    }

    public void zza(Rect rect) {
        this.kt.set(rect);
        this.centerX = this.kt.exactCenterX();
        this.centerY = this.kt.exactCenterY();
        this.kp = Math.max((float)this.kP, Math.max((float)this.kt.width() / 2.0f, (float)this.kt.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zzaju() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzaes.zzcjr());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzajv() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzaes.zzcjt());
        animatorSet.setStartDelay(500L);
        animatorSet.addListener((Animator.AnimatorListener)zzaeq.zzc((Animator)animatorSet));
        return animatorSet;
    }

    public Animator zzajw() {
        return this.zzajx();
    }

    public Animator zzajx() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzaes.zzcjs());
        return objectAnimator.setDuration(200L);
    }
}

