/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.zzd;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class NotificationOptions
extends AbstractSafeParcelable {
    public static final long SKIP_STEP_TEN_SECONDS_IN_MS = 10000L;
    public static final long SKIP_STEP_THIRTY_SECONDS_IN_MS = 30000L;
    private static final List<String> lm = Arrays.asList("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK", "com.google.android.gms.cast.framework.action.STOP_CASTING");
    private static final int[] ln = new int[]{0, 1};
    public static final Parcelable.Creator<NotificationOptions> CREATOR = new zzd();
    private final int mVersionCode;
    private final List<String> lo;
    private final int[] lp;
    private final long lq;
    private final String lr;
    private final int ls;
    private final int lt;
    private final int lu;
    private final int lv;
    private final int lw;
    private final int lx;
    private final int ly;
    private final int lz;
    private final int lA;
    private final int lB;
    private final int lC;
    private final int lD;
    private final int lE;
    private final int lF;
    private final int lG;
    private final int lH;
    private final int lI;
    private final int lJ;
    private final int lK;
    private final int lL;
    private final int lM;
    private final int lN;
    private final int lO;
    private final int lP;
    private final int lQ;
    private final int lR;
    private final int lS;

    public NotificationOptions(int n, List<String> list, int[] nArray, long l, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28) {
        this.mVersionCode = n;
        this.lo = list != null ? new ArrayList<String>(list) : null;
        this.lp = (int[])(nArray != null ? Arrays.copyOf(nArray, nArray.length) : null);
        this.lq = l;
        this.lr = string2;
        this.ls = n2;
        this.lt = n3;
        this.lu = n4;
        this.lv = n5;
        this.lw = n6;
        this.lx = n7;
        this.ly = n8;
        this.lz = n9;
        this.lA = n10;
        this.lB = n11;
        this.lC = n12;
        this.lD = n13;
        this.lE = n14;
        this.lF = n15;
        this.lG = n16;
        this.lH = n17;
        this.lI = n18;
        this.lJ = n19;
        this.lK = n20;
        this.lL = n21;
        this.lM = n22;
        this.lN = n23;
        this.lO = n24;
        this.lP = n25;
        this.lQ = n26;
        this.lR = n27;
        this.lS = n28;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public List<String> getActions() {
        return this.lo;
    }

    public int[] getCompatActionIndices() {
        return Arrays.copyOf(this.lp, this.lp.length);
    }

    public long getSkipStepMs() {
        return this.lq;
    }

    public String getTargetActivityClassName() {
        return this.lr;
    }

    public int getSmallIconDrawableResId() {
        return this.ls;
    }

    public int getStopLiveStreamDrawableResId() {
        return this.lt;
    }

    public int getPauseDrawableResId() {
        return this.lu;
    }

    public int getPlayDrawableResId() {
        return this.lv;
    }

    public int getSkipNextDrawableResId() {
        return this.lw;
    }

    public int getSkipPrevDrawableResId() {
        return this.lx;
    }

    public int getForwardDrawableResId() {
        return this.ly;
    }

    public int getForward10DrawableResId() {
        return this.lz;
    }

    public int getForward30DrawableResId() {
        return this.lA;
    }

    public int getRewindDrawableResId() {
        return this.lB;
    }

    public int getRewind10DrawableResId() {
        return this.lC;
    }

    public int getRewind30DrawableResId() {
        return this.lD;
    }

    public int getDisconnectDrawableResId() {
        return this.lE;
    }

    public int zzakb() {
        return this.lF;
    }

    public int zzakc() {
        return this.lG;
    }

    public int zzakd() {
        return this.lH;
    }

    public int zzake() {
        return this.lI;
    }

    public int zzakf() {
        return this.lJ;
    }

    public int zzakg() {
        return this.lK;
    }

    public int zzakh() {
        return this.lL;
    }

    public int zzaki() {
        return this.lM;
    }

    public int zzakj() {
        return this.lN;
    }

    public int zzakk() {
        return this.lO;
    }

    public int zzakl() {
        return this.lP;
    }

    public int zzakm() {
        return this.lQ;
    }

    public int zzakn() {
        return this.lR;
    }

    public int zzako() {
        return this.lS;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NotificationOptions(actions=%s, compatActionIndices=%s, skipStepMs=%s, targetActivityClassName=%s)", this.lo, Arrays.toString(this.lp), this.lq, this.lr);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions notificationOptions = (NotificationOptions)((Object)object);
        return zzf.zza(this.lo, notificationOptions.lo) && Arrays.equals(this.lp, notificationOptions.lp) && this.lq == notificationOptions.lq && zzf.zza((Object)this.lr, (Object)notificationOptions.lr);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.lo, Arrays.hashCode(this.lp), this.lq, this.lr});
    }

    public static final class Builder {
        private String lr;
        private List<String> lo = NotificationOptions.zzakp();
        private int[] lp = NotificationOptions.zzakq();
        private long lq = 10000L;

        public Builder setActions(List<String> list, int[] nArray) {
            if (list == null && nArray != null) {
                throw new IllegalArgumentException("When setting actions to null, you must also set compatActionIndices to null.");
            }
            if (list != null && nArray == null) {
                throw new IllegalArgumentException("When setting compatActionIndices to null, you must also set actions to null.");
            }
            if (list != null && nArray != null) {
                int n = list.size();
                if (nArray.length > n) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid number of compat actions: %d > %d.", nArray.length, n));
                }
                for (int n2 : nArray) {
                    if (n2 >= 0 && n2 < n) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Index %d in compatActionIndices out of range: [0, %d]", n2, n - 1));
                }
                this.lo = new ArrayList<String>(list);
                this.lp = Arrays.copyOf(nArray, nArray.length);
            } else {
                this.lo = lm;
                this.lp = ln;
            }
            return this;
        }

        public Builder setSkipStepMs(long l) {
            zzab.zzb((l > 0L ? 1 : 0) != 0, (Object)"skipStepMs must be positive.");
            this.lq = l;
            return this;
        }

        public Builder setTargetActivityClassName(String string2) {
            this.lr = string2;
            return this;
        }

        public NotificationOptions build() {
            return new NotificationOptions(1, this.lo, this.lp, this.lq, this.lr, R.drawable.cast_ic_notification_small_icon, R.drawable.cast_ic_notification_stop_live_stream, R.drawable.cast_ic_notification_pause, R.drawable.cast_ic_notification_play, R.drawable.cast_ic_notification_skip_next, R.drawable.cast_ic_notification_skip_prev, R.drawable.cast_ic_notification_forward, R.drawable.cast_ic_notification_forward10, R.drawable.cast_ic_notification_forward30, R.drawable.cast_ic_notification_rewind, R.drawable.cast_ic_notification_rewind10, R.drawable.cast_ic_notification_rewind30, R.drawable.cast_ic_notification_disconnect, R.dimen.cast_notification_image_size, R.string.cast_casting_to_device, R.string.cast_stop_live_stream, R.string.cast_pause, R.string.cast_play, R.string.cast_skip_next, R.string.cast_skip_prev, R.string.cast_forward, R.string.cast_forward_10, R.string.cast_forward_30, R.string.cast_rewind, R.string.cast_rewind_10, R.string.cast_rewind_30, R.string.cast_disconnect);
        }
    }
}

