/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpm;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object zzail;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final zzn it;
    private final zza lT;
    private final Cast.CastApi jF;
    private GoogleApiClient lU;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> lV = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> lW = new ConcurrentHashMap<Long, zzd>();
    public static final String NAMESPACE = zzn.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzn zzn2, @NonNull Cast.CastApi castApi) {
        this.zzail = new Object();
        this.lT = new zza();
        this.jF = castApi;
        this.it = (zzn)zzab.zzy((Object)zzn2);
        this.it.zza(new zzn.zza(){

            public void onStatusUpdated() {
                RemoteMediaClient.this.zzaks();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onStatusUpdated();
                }
            }

            public void onMetadataUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onMetadataUpdated();
                }
            }

            public void onQueueStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onQueueStatusUpdated();
                }
            }

            public void onPreloadStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onPreloadStatusUpdated();
                }
            }
        });
        this.it.zza((zzo)this.lT);
    }

    public void zzd(GoogleApiClient googleApiClient) throws IOException {
        if (this.lU == googleApiClient) {
            return;
        }
        if (this.lU != null) {
            this.it.zzame();
            this.jF.removeMessageReceivedCallbacks(this.lU, this.getNamespace());
            this.lT.zzc(null);
        }
        this.lU = googleApiClient;
        if (this.lU != null) {
            this.jF.setMessageReceivedCallbacks(this.lU, this.getNamespace(), (Cast.MessageReceivedCallback)this);
            this.lT.zzc(this.lU);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zzb(this.jb, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zzc(this.jb, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final long l, final int n, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, l, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzakr();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, d, jSONObject);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final boolean bl, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, bl, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final long[] lArray) {
        this.zzakr();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, lArray);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final TextTrackStyle textTrackStyle) {
        this.zzakr();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, textTrackStyle);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, nArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, nArray, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final int n, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, 0, -1L, null, 0, Integer.valueOf(n), jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final int n, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzef(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, new int[]{n}, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final int n, final long l, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzef(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, n, l, null, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final int n, final int n2, final JSONObject jSONObject) {
        this.zzakr();
        return this.zza(new zzb(this.lU){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzail;
                synchronized (object) {
                    int n4 = RemoteMediaClient.this.zzef(n);
                    if (n4 == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaClient.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    try {
                        RemoteMediaClient.this.it.zza(this.jb, new int[]{n}, n3, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    private int zzef(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzail;
        synchronized (object) {
            return this.it.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzail;
        synchronized (object) {
            return this.it.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzail;
        synchronized (object) {
            return this.it.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzail;
        synchronized (object) {
            return this.it.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.zzail;
        synchronized (object) {
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.zzail;
        synchronized (object) {
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
        } else {
            this.play();
        }
    }

    public boolean hasMediaSession() {
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        if (progressListener == null || this.lV.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.lW.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.lW.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.lV.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzd zzd2 = this.lV.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzaku()) {
                this.lW.remove(zzd2.zzakt());
                zzd2.stop();
            }
        }
    }

    public String getNamespace() {
        return this.it.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.it.zzgi(string3);
    }

    private void zzakr() throws IllegalStateException {
        if (this.lU == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private zzb zza(zzb zzb2) {
        try {
            this.lU.zzd((zzpm.zza)zzb2);
        }
        catch (IllegalStateException illegalStateException) {
            zzb2.zzc((MediaChannelResult)zzb2.zzc(new Status(2100)));
        }
        finally {
            return zzb2;
        }
    }

    private void zza(Set<ProgressListener> set) {
        block5: {
            HashSet<ProgressListener> hashSet;
            block6: {
                block4: {
                    if (this.isBuffering() || this.isPaused()) {
                        return;
                    }
                    hashSet = new HashSet<ProgressListener>(set);
                    if (!this.isPlaying()) break block4;
                    for (ProgressListener progressListener : hashSet) {
                        progressListener.onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
                    }
                    break block5;
                }
                if (!this.isLoadingNextItem()) break block6;
                MediaQueueItem mediaQueueItem = this.getLoadingItem();
                if (mediaQueueItem == null || mediaQueueItem.getMedia() == null) break block5;
                for (ProgressListener progressListener : hashSet) {
                    progressListener.onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
                break block5;
            }
            for (ProgressListener progressListener : hashSet) {
                progressListener.onProgressUpdated(0L, 0L);
            }
        }
    }

    private void zzaks() {
        for (zzd zzd2 : this.lW.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.mb);
        }
    }

    private class zzd {
        private final Set<ProgressListener> mb = new HashSet<ProgressListener>();
        private final long mc;
        private final Runnable md;
        private boolean me;

        public zzd(long l) {
            this.mc = l;
            this.md = new TimerTask(){

                @Override
                public void run() {
                    RemoteMediaClient.this.zza(zzd.this.mb);
                    RemoteMediaClient.this.mHandler.postDelayed((Runnable)this, zzd.this.mc);
                }
            };
        }

        public long zzakt() {
            return this.mc;
        }

        public void zza(ProgressListener progressListener) {
            this.mb.add(progressListener);
        }

        public void zzb(ProgressListener progressListener) {
            this.mb.remove(progressListener);
        }

        public boolean zzaku() {
            return !this.mb.isEmpty();
        }

        public void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.md);
            this.me = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.md, this.mc);
        }

        public void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.md);
            this.me = false;
        }

        public boolean isStarted() {
            return this.me;
        }
    }

    static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzp jb = new zzp(){

            public void zzaa(long l) {
                zzb.this.zzc((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzc(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzr(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zze zze2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status bY;
        private final JSONObject hJ;

        zzc(Status status, JSONObject jSONObject) {
            this.bY = status;
            this.hJ = jSONObject;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public JSONObject getCustomData() {
            return this.hJ;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.framework.media.RemoteMediaClient$zza
    implements zzo {
        private GoogleApiClient iX;
        private long iY = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.iX = googleApiClient;
        }

        public long zzaii() {
            return ++this.iY;
        }

        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.iX == null) {
                throw new IOException("No GoogleApiClient available");
            }
            for (Listener listener : RemoteMediaClient.this.mListeners) {
                listener.onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.jF.sendMessage(this.iX, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long iZ;

            zza(long l) {
                this.iZ = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaClient.this.it.zzb(this.iZ, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();
    }
}

