/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import java.lang.ref.WeakReference;
import java.util.List;

public class zznw
extends UIController {
    private final View mView;
    private final WeakReference<Activity> mD;
    private final String mE;
    private final String mF;
    private final View.OnClickListener mG;

    public zznw(View view, Activity activity) {
        this.mView = view;
        this.mE = activity.getString(R.string.cast_closed_captions);
        this.mF = activity.getString(R.string.cast_closed_captions_unavailable);
        this.mD = new WeakReference<Activity>(activity);
        this.mG = new View.OnClickListener(){

            public void onClick(View view) {
                Activity activity = (Activity)zznw.this.mD.get();
                if (activity == null) {
                    return;
                }
                RemoteMediaClient remoteMediaClient = zznw.this.getRemoteMediaClient();
                if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                    return;
                }
                if (activity instanceof FragmentActivity) {
                    FragmentActivity fragmentActivity = (FragmentActivity)activity;
                    FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
                    Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
                    if (fragment != null) {
                        fragmentTransaction.remove(fragment);
                    }
                    fragmentTransaction.addToBackStack(null);
                    MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
                    long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
                    TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
                    if (tracksChooserDialogFragment != null) {
                        tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
                    }
                }
            }
        };
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.mView.setOnClickListener(this.mG);
        this.zzalg();
    }

    @Override
    public void onSessionEnded() {
        this.mView.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzalg();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.mView.setEnabled(false);
    }

    private void zzalg() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !this.zzb(remoteMediaClient.getMediaInfo())) {
            this.mView.setEnabled(false);
            this.mView.setContentDescription((CharSequence)this.mF);
        } else {
            this.mView.setEnabled(true);
            this.mView.setContentDescription((CharSequence)this.mE);
        }
    }

    private boolean zzb(MediaInfo mediaInfo) {
        if (mediaInfo == null) {
            return false;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (MediaTrack mediaTrack : list) {
            if (mediaTrack.getType() != 2 && mediaTrack.getType() != 1) continue;
            return true;
        }
        return false;
    }
}

