/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqc;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object zzakd;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final zzn lQ;
    private final zza pr;
    private final Cast.CastApi nc;
    private GoogleApiClient ps;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> pt = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> pu = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback pv;
    public static final String NAMESPACE = zzn.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzn zzn2, @NonNull Cast.CastApi castApi) {
        this.zzakd = new Object();
        this.pr = new zza();
        this.nc = castApi;
        this.lQ = (zzn)zzac.zzy((Object)zzn2);
        this.lQ.zza(new zzn.zza(){

            public void onStatusUpdated() {
                this.zzamm();
                RemoteMediaClient.this.zzaml();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onStatusUpdated();
                }
            }

            public void onMetadataUpdated() {
                this.zzamm();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onMetadataUpdated();
                }
            }

            public void onQueueStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onQueueStatusUpdated();
                }
            }

            public void onPreloadStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onPreloadStatusUpdated();
                }
            }

            private void zzamm() {
                MediaStatus mediaStatus;
                if (RemoteMediaClient.this.pv != null && (mediaStatus = RemoteMediaClient.this.getMediaStatus()) != null) {
                    mediaStatus.zzbk(RemoteMediaClient.this.pv.parseIsPlayingAdFromMediaStatus(mediaStatus));
                    List<AdBreakInfo> list = RemoteMediaClient.this.pv.parseAdBreaksFromMediaStatus(mediaStatus);
                    MediaInfo mediaInfo = RemoteMediaClient.this.getMediaInfo();
                    if (mediaInfo != null) {
                        mediaInfo.zzy(list);
                    }
                }
            }
        });
        this.lQ.zza((zzo)this.pr);
    }

    public void zzd(GoogleApiClient googleApiClient) throws IOException {
        if (this.ps == googleApiClient) {
            return;
        }
        if (this.ps != null) {
            this.lQ.zzaob();
            this.nc.removeMessageReceivedCallbacks(this.ps, this.getNamespace());
            this.pr.zzc(null);
        }
        this.ps = googleApiClient;
        if (this.ps != null) {
            this.nc.setMessageReceivedCallbacks(this.ps, this.getNamespace(), (Cast.MessageReceivedCallback)this);
            this.pr.zzc(this.ps);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zzb(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zzc(this.my, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final long l, final int n, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, l, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzamk();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, d, jSONObject);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final boolean bl, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, bl, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final long[] lArray) {
        this.zzamk();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, lArray);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final TextTrackStyle textTrackStyle) {
        this.zzamk();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, textTrackStyle);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, nArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, nArray, n, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final int n, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, 0, -1L, null, 0, Integer.valueOf(n), jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final int n, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzem(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, new int[]{n}, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final int n, final long l, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzem(n) == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, n, l, null, 0, null, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final int n, final int n2, final JSONObject jSONObject) {
        this.zzamk();
        return this.zza(new zzb(this.ps){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zze zze2) {
                Object object = RemoteMediaClient.this.zzakd;
                synchronized (object) {
                    int n4 = RemoteMediaClient.this.zzem(n);
                    if (n4 == -1) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaClient.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    try {
                        RemoteMediaClient.this.lQ.zza(this.my, new int[]{n}, n3, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzc((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    private int zzem(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzakd;
        synchronized (object) {
            return this.lQ.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.zzakd;
        synchronized (object) {
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.zzakd;
        synchronized (object) {
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
        } else {
            this.play();
        }
    }

    public boolean hasMediaSession() {
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        if (progressListener == null || this.pt.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.pu.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.pu.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.pt.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzd zzd2 = this.pt.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzamo()) {
                this.pu.remove(zzd2.zzamn());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        this.pv = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        return this.lQ.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.lQ.zzgq(string3);
    }

    private void zzamk() throws IllegalStateException {
        if (this.ps == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private zzb zza(zzb zzb2) {
        try {
            this.ps.zzd((zzqc.zza)zzb2);
        }
        catch (IllegalStateException illegalStateException) {
            zzb2.zzc((MediaChannelResult)zzb2.zzc(new Status(2100)));
        }
        finally {
            return zzb2;
        }
    }

    private void zza(Set<ProgressListener> set) {
        block5: {
            HashSet<ProgressListener> hashSet;
            block6: {
                block4: {
                    if (this.isBuffering() || this.isPaused()) {
                        return;
                    }
                    hashSet = new HashSet<ProgressListener>(set);
                    if (!this.isPlaying()) break block4;
                    for (ProgressListener progressListener : hashSet) {
                        progressListener.onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
                    }
                    break block5;
                }
                if (!this.isLoadingNextItem()) break block6;
                MediaQueueItem mediaQueueItem = this.getLoadingItem();
                if (mediaQueueItem == null || mediaQueueItem.getMedia() == null) break block5;
                for (ProgressListener progressListener : hashSet) {
                    progressListener.onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
                break block5;
            }
            for (ProgressListener progressListener : hashSet) {
                progressListener.onProgressUpdated(0L, 0L);
            }
        }
    }

    private void zzaml() {
        for (zzd zzd2 : this.pu.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.pA);
        }
    }

    private class zzd {
        private final Set<ProgressListener> pA = new HashSet<ProgressListener>();
        private final long pB;
        private final Runnable pC;
        private boolean pD;

        public zzd(long l) {
            this.pB = l;
            this.pC = new TimerTask(){

                @Override
                public void run() {
                    RemoteMediaClient.this.zza(zzd.this.pA);
                    RemoteMediaClient.this.mHandler.postDelayed((Runnable)this, zzd.this.pB);
                }
            };
        }

        public long zzamn() {
            return this.pB;
        }

        public void zza(ProgressListener progressListener) {
            this.pA.add(progressListener);
        }

        public void zzb(ProgressListener progressListener) {
            this.pA.remove(progressListener);
        }

        public boolean zzamo() {
            return !this.pA.isEmpty();
        }

        public void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.pC);
            this.pD = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.pC, this.pB);
        }

        public void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.pC);
            this.pD = false;
        }

        public boolean isStarted() {
            return this.pD;
        }
    }

    static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzp my = new zzp(){

            public void zzac(long l) {
                zzb.this.zzc((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzc(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzr(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zze zze2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status fp;
        private final JSONObject lh;

        zzc(Status status, JSONObject jSONObject) {
            this.fp = status;
            this.lh = jSONObject;
        }

        public Status getStatus() {
            return this.fp;
        }

        @Override
        public JSONObject getCustomData() {
            return this.lh;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.framework.media.RemoteMediaClient$zza
    implements zzo {
        private GoogleApiClient mu;
        private long mv = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.mu = googleApiClient;
        }

        public long zzakb() {
            return ++this.mv;
        }

        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.mu == null) {
                throw new IOException("No GoogleApiClient available");
            }
            for (Listener listener : RemoteMediaClient.this.mListeners) {
                listener.onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.nc.sendMessage(this.mu, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long mw;

            zza(long l) {
                this.mw = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaClient.this.lQ.zzb(this.mw, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();
    }
}

