/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final int mVersionCode;
    private final String pb;
    private final List<String> pc;
    private final boolean pd;
    private final LaunchOptions nf;
    private final boolean pe;
    private final CastMediaOptions pf;
    private final boolean pg;
    private final double ph;

    CastOptions(int n, String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.mVersionCode = n;
        this.pb = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n2 = list == null ? 0 : list.size();
        this.pc = new ArrayList<String>(n2);
        if (n2 > 0) {
            this.pc.addAll(list);
        }
        this.pd = bl;
        this.nf = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.pe = bl2;
        this.pf = castMediaOptions;
        this.pg = bl3;
        this.ph = d;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getReceiverApplicationId() {
        return this.pb;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.pc);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.pd;
    }

    public LaunchOptions getLaunchOptions() {
        return this.nf;
    }

    public boolean getResumeSavedSession() {
        return this.pe;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.pf;
    }

    public boolean getEnableReconnectionService() {
        return this.pg;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.ph;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public static final class Builder {
        private String pb;
        private List<String> pc = new ArrayList<String>();
        private boolean pd;
        private LaunchOptions nf = new LaunchOptions();
        private boolean pe = true;
        private CastMediaOptions pf = new CastMediaOptions.Builder().build();
        private boolean pg = true;
        private double ph = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.pb = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.pc = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.pd = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.nf = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.pe = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.pf = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.pg = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.ph = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(1, this.pb, this.pc, this.pd, this.nf, this.pe, this.pf, this.pg, this.ph);
        }
    }
}

