/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzou;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzm oT = new zzm("CastSession");
    private final Context zzcfo;
    private final Set<Cast.Listener> pi = new HashSet<Cast.Listener>();
    private final zzh pj;
    private final Cast.CastApi pk;
    private final zzoi pl;
    private final zzou pm;
    private GoogleApiClient mD;
    private RemoteMediaClient pn;
    private CastDevice po;
    private Cast.ApplicationConnectionResult pp;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzoi zzoi2, zzou zzou2) {
        super(context, string2, string3);
        this.zzcfo = context.getApplicationContext();
        this.pk = castApi;
        this.pl = zzoi2;
        this.pm = zzou2;
        this.pj = zzog.zza(context, castOptions, this.zzalz(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzk(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzk(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.pj.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.pn;
    }

    public CastDevice getCastDevice() {
        return this.po;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        if (this.mD != null) {
            this.pk.requestStatus(this.mD);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        return this.mD != null ? this.pk.getActiveInputState(this.mD) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        return this.mD != null ? this.pk.getStandbyState(this.mD) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        return this.mD != null ? this.pk.getApplicationMetadata(this.mD) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        return this.mD != null ? this.pk.getApplicationStatus(this.mD) : null;
    }

    public void setVolume(double d) throws IOException {
        if (this.mD != null) {
            this.pk.setVolume(this.mD, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        return this.mD != null ? this.pk.getVolume(this.mD) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        if (this.mD != null) {
            this.pk.setMute(this.mD, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        return this.mD != null ? this.pk.isMute(this.mD) : false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        return this.pp;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        if (this.mD != null) {
            this.pk.setMessageReceivedCallbacks(this.mD, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        if (this.mD != null) {
            this.pk.removeMessageReceivedCallbacks(this.mD, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        return this.mD != null ? this.pk.sendMessage(this.mD, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.pi.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.pi.remove(listener);
        }
    }

    private void zzk(Bundle bundle) {
        this.po = CastDevice.getFromBundle((Bundle)bundle);
        if (this.po == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.mD != null) {
            this.mD.disconnect();
            this.mD = null;
        }
        oT.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.po});
        zzd zzd2 = new zzd();
        this.mD = this.pl.zza(this.zzcfo, this.po, new zzc(), zzd2, zzd2);
        this.mD.connect();
    }

    private void zzes(int n) {
        this.pm.zzey(n);
        if (this.mD != null) {
            this.mD.disconnect();
            this.mD = null;
        }
        this.po = null;
        if (this.pn != null) {
            try {
                this.pn.zzd(null);
            }
            catch (IOException iOException) {
                oT.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.pn = null;
        }
        this.pp = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        if (this.pn == null) {
            return 0L;
        }
        return this.pn.getStreamDuration() - this.pn.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzalm() {
            return 9877208;
        }

        @Override
        public void zzy(String string, String string2) {
            CastSession.this.pk.joinApplication(CastSession.this.mD, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.pk.launchApplication(CastSession.this.mD, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzgo(String string) {
            CastSession.this.pk.stopApplication(CastSession.this.mD, string);
        }

        @Override
        public void zzes(int n) {
            CastSession.this.zzes(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String pq;

        zza(String string) {
            this.pq = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                CastSession.this.pp = applicationConnectionResult;
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        oT.zzb("%s() -> success result", new Object[]{this.pq});
                        CastSession.this.pn = new RemoteMediaClient(new zzn(null), CastSession.this.pk);
                        try {
                            CastSession.this.pn.zzd(CastSession.this.mD);
                            CastSession.this.pn.requestStatus();
                            CastSession.this.pm.zza(CastSession.this.pn, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            oT.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.pn = null;
                        }
                        CastSession.this.pj.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    oT.zzb("%s() -> failure result", new Object[]{this.pq});
                    CastSession.this.pj.zzet(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzes(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.pi);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                CastSession.this.pj.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.pj.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.pj.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

