/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzagr;
import com.google.android.gms.internal.zzagt;

class zzc
extends Drawable {
    private final Paint pU = new Paint();
    private final Paint qu = new Paint();
    private final Rect pZ = new Rect();
    private final int qv;
    private final int qw;
    private float pV;
    private float qx = 1.0f;
    private float centerX;
    private float centerY;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.qv = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.qw = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.pU.setAntiAlias(true);
        this.pU.setStyle(Paint.Style.FILL);
        this.qu.setAntiAlias(true);
        this.qu.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        float f = 0.0f - 0.0f;
        int cfr_ignored_1 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        canvas.drawCircle(this.centerX, this.centerY, this.pV * this.qx, this.pU);
    }

    public void setAlpha(int n) {
        this.pU.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.pU.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(@ColorInt int n) {
        this.pU.setColor(n);
        this.qu.setColor(n);
        this.invalidateSelf();
    }

    public void zzc(Rect rect) {
        this.pZ.set(rect);
        this.centerX = this.pZ.exactCenterX();
        this.centerY = this.pZ.exactCenterY();
        this.pV = Math.max((float)this.qv, Math.max((float)this.pZ.width() / 2.0f, (float)this.pZ.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zzamw() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzagt.zzcnl());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzamx() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzagt.zzcnn());
        animatorSet.setStartDelay(500L);
        animatorSet.addListener((Animator.AnimatorListener)zzagr.zzc((Animator)animatorSet));
        return animatorSet;
    }

    public Animator zzamy() {
        return this.zzamz();
    }

    public Animator zzamz() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzagt.zzcnm());
        return objectAnimator.setDuration(200L);
    }
}

