/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzox;
import com.google.android.gms.internal.zzoy;
import com.google.android.gms.internal.zzoz;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzpg;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpl;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager oX;
    private final Map<View, List<UIController>> st = new HashMap<View, List<UIController>>();
    private final Set<zzpm> su = new HashSet<zzpm>();
    private RemoteMediaClient.Listener sv;
    private RemoteMediaClient pn;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.oX = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.oX.addSessionManagerListener(this, CastSession.class);
        this.zza(this.oX.getCurrentCastSession());
    }

    public boolean isActive() {
        return this.pn != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.pn;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        this.sv = listener;
    }

    public void dispose() {
        this.zzaof();
        this.st.clear();
        this.oX.removeSessionManagerListener(this, CastSession.class);
        this.sv = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zza((View)imageView, new zzpf(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        this.zza(view, new zzpj(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        this.zza(view, new zzpk(view, n));
    }

    public void bindViewToForward(View view, long l) {
        this.zza(view, new zzpi(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        this.zza(view, new zzpb(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        this.zza((View)progressBar, new zzpg(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                for (zzpm zzpm2 : UIMediaController.this.su) {
                    zzpm2.zzbo(true);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                for (zzpm zzpm2 : UIMediaController.this.su) {
                    zzpm2.zzbo(false);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzpm zzpm2 : UIMediaController.this.su) {
                        zzpm2.zzad(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzph(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzpm zzpm2 = new zzpm(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.su.add(zzpm2);
        }
        this.zza((View)textView, zzpm2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        this.zza((View)textView, new zzpl(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        this.zza((View)textView, new zzpl(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        this.zza(view, new zzoz(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        this.zza(view, new zzow(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        this.zza((View)imageView, new zzpe(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzpd(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzoy(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        this.zza((View)imageView, new zzoy(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        this.zza((View)imageView, new zzoy(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        this.zza((View)imageView, new zzoy(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        this.zza(view, new zzpo(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzpc(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzox(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        this.zza((View)imageView, new zzox(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        this.zza(view, new zzpn(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        this.zza(view, uIController);
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzaof();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzaof();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzaof();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzaog();
        if (this.sv != null) {
            this.sv.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzaog();
        if (this.sv != null) {
            this.sv.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzaog();
        if (this.sv != null) {
            this.sv.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzaog();
        if (this.sv != null) {
            this.sv.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (List<UIController> list : this.st.values()) {
            for (UIController uIController : list) {
                uIController.onSendingRemoteMediaRequest();
            }
        }
        if (this.sv != null) {
            this.sv.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.pn = castSession.getRemoteMediaClient();
        if (this.pn != null) {
            this.pn.addListener(this);
            for (List<UIController> list : this.st.values()) {
                for (UIController uIController : list) {
                    uIController.onSessionConnected(castSession);
                }
            }
            this.zzaog();
        }
    }

    private void zzaof() {
        if (!this.isActive()) {
            return;
        }
        for (List<UIController> list : this.st.values()) {
            for (UIController uIController : list) {
                uIController.onSessionEnded();
            }
        }
        this.pn.removeListener(this);
        this.pn = null;
    }

    private void zza(View view, UIController uIController) {
        List<UIController> list = this.st.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.st.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.oX.getCurrentCastSession());
            this.zzaog();
        }
    }

    private void zzaog() {
        for (List<UIController> list : this.st.values()) {
            for (UIController uIController : list) {
                uIController.onMediaStatusUpdated();
            }
        }
    }
}

