/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzaa;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzm oT = new zzm("MiniControllerFragment");
    private boolean tD;
    private int tE;
    private int tF;
    private int tG;
    private int tH;
    private int tI;
    private int[] ty;
    private ImageView[] tz = new ImageView[3];
    private int tJ;
    private UIMediaController tB;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        this.zza(context, attributeSet);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.tB = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.tB.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.tG != 0) {
            relativeLayout.setBackgroundResource(this.tG);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.tE != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.tE);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.tF != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.tF);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.tH != 0) {
            LayerDrawable layerDrawable = (LayerDrawable)progressBar.getProgressDrawable();
            layerDrawable.setColorFilter(this.tH, PorterDuff.Mode.SRC_IN);
        }
        this.tB.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.tB.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.tB.bindProgressBar(progressBar);
        this.tB.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.tD) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.tB.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.tz[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.tz[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.tz[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.tB != null) {
            this.tB.dispose();
            this.tB = null;
        }
        super.onDestroy();
    }

    private void zza(Context context, AttributeSet attributeSet) {
        if (this.ty != null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.tD = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.tE = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.tF = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        this.tG = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
        this.tH = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
        this.tI = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
        int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = context.getResources().obtainTypedArray(n);
            zzaa.zzbt((typedArray2.length() == 3 ? 1 : 0) != 0);
            this.ty = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.ty[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            if (this.tD) {
                this.ty[0] = R.id.cast_button_type_empty;
            }
            this.tJ = 0;
            for (int n2 : this.ty) {
                if (n2 == R.id.cast_button_type_empty) continue;
                ++this.tJ;
            }
        } else {
            oT.zzf("Unable to read attribute castControlButtons.", new Object[0]);
            this.ty = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.ty[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.tz[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.tB;
    }

    private void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.ty[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = R.drawable.cast_ic_mini_controller_play;
                int n5 = R.drawable.cast_ic_mini_controller_pause;
                int n6 = R.drawable.cast_ic_mini_controller_stop;
                if (this.tJ == 1) {
                    n4 = R.drawable.cast_ic_mini_controller_play_large;
                    n5 = R.drawable.cast_ic_mini_controller_pause_large;
                    n6 = R.drawable.cast_ic_mini_controller_stop_large;
                }
                Drawable drawable2 = this.zzfb(n4);
                Drawable drawable3 = this.zzfb(n5);
                Drawable drawable4 = this.zzfb(n6);
                imageView.setImageDrawable(drawable3);
                ProgressBar progressBar = this.zzfa(n);
                relativeLayout.addView((View)progressBar);
                this.tB.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
            } else if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_skip_prev));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.tB.bindViewToSkipPrev((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_skip_next));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.tB.bindViewToSkipNext((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_rewind30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.tB.bindViewToRewind((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_forward30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.tB.bindViewToForward((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_mute));
                this.tB.bindImageViewToMuteToggle(imageView);
            } else if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(this.zzfb(R.drawable.cast_ic_mini_controller_closed_caption));
                this.tB.bindViewToClosedCaption((View)imageView);
            }
        }
    }

    private ProgressBar zzfa(int n) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(8, n);
        layoutParams.addRule(6, n);
        layoutParams.addRule(5, n);
        layoutParams.addRule(7, n);
        layoutParams.addRule(15);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressBar.setVisibility(8);
        Drawable drawable2 = progressBar.getIndeterminateDrawable();
        if (this.tH != 0 && drawable2 != null) {
            drawable2.setColorFilter(this.tH, PorterDuff.Mode.SRC_IN);
        }
        return progressBar;
    }

    private Drawable zzfb(@DrawableRes int n) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getResources().getDrawable(n).mutate());
        DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)PorterDuff.Mode.SRC_IN);
        ColorStateList colorStateList = null;
        if (this.tI != 0) {
            colorStateList = ContextCompat.getColorStateList((Context)this.getContext(), (int)this.tI);
        } else {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(new int[]{0x1010030});
            int n2 = typedArray.getColor(0, 0);
            typedArray.recycle();
            int n3 = ColorUtils.setAlphaComponent((int)n2, (int)128);
            int[] nArray = new int[]{n2, n3};
            int[][] nArrayArray = new int[][]{{16842910}, {-16842910}};
            colorStateList = new ColorStateList((int[][])nArrayArray, nArray);
        }
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
        return drawable2;
    }
}

