/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzom;

public class zzon
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean pL;
    private Activity mActivity;
    private int pQ;
    private boolean pN;
    private IntroductoryOverlay.OnOverlayDismissedListener px;
    private final zza pR;

    public zzon(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    @TargetApi(value=14)
    public zzon(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), attributeSet, n);
        Rect rect;
        this.mActivity = builder.getActivity();
        this.pL = builder.zzamg();
        this.px = builder.zzame();
        TypedArray typedArray = this.mActivity.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzamd() != null) {
            rect = new Rect();
            builder.zzamd().getGlobalVisibleRect(rect);
            this.pR = new zza();
            this.pR.x = rect.centerX();
            this.pR.y = rect.centerY();
            this.pR.pU = this.zzamp();
            this.pR.pV = builder.zzamj();
            if (this.pR.pV == 0.0f) {
                this.pR.pV = typedArray.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.pR = null;
        }
        rect = LayoutInflater.from((Context)this.mActivity);
        rect.inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.pQ = builder.zzamf();
        if (this.pQ == 0) {
            this.pQ = typedArray.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzamh())) {
            textView.setText((CharSequence)builder.zzamh());
            int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        this.zza(builder.zzami(), typedArray);
        typedArray.recycle();
        if (Build.VERSION.SDK_INT >= 14) {
            this.setFitsSystemWindows(true);
        }
    }

    @Override
    public void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzom.zzbf((Context)this.mActivity)) {
            return;
        }
        if (this.pL && IntroductoryOverlay.zza.zzbd((Context)this.mActivity)) {
            this.mActivity = null;
            this.px = null;
            return;
        }
        if (!this.pN) {
            this.pN = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.px = null;
    }

    @TargetApi(value=11)
    private void zza(String string2, TypedArray typedArray) {
        String string3 = string2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string3 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)this.findViewById(R.id.button);
        button.setText((CharSequence)string3);
        button.getBackground().setColorFilter(n, PorterDuff.Mode.MULTIPLY);
        int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n2 != 0) {
            button.setTextAppearance((Context)this.mActivity, n2);
        }
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Build.VERSION.SDK_INT >= 16) {
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f});
                    objectAnimator.setDuration(400L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            zzon.this.zzamq();
                        }
                    });
                    objectAnimator.start();
                } else {
                    zzon.this.zzamq();
                }
            }
        });
    }

    private Paint zzamp() {
        PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAlpha(0);
        paint.setXfermode((Xfermode)porterDuffXfermode);
        paint.setAntiAlias(true);
        return paint;
    }

    protected void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.pQ);
        if (this.pR != null) {
            canvas2.drawCircle((float)this.pR.x, (float)this.pR.y, this.pR.pV, this.pR.pU);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private void zzamq() {
        IntroductoryOverlay.zza.zzbc((Context)this.mActivity);
        if (this.px != null) {
            this.px.onOverlayDismissed();
            this.px = null;
        }
        this.remove();
    }

    private static class zza {
        public int x;
        public int y;
        public Paint pU;
        public float pV;

        private zza() {
        }
    }
}

