/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzoq;

public class zzou
implements RemoteMediaClient.Listener {
    private final Context zzcfo;
    private final CastOptions si;
    private final zzop pK;
    private final ComponentName sj;
    private final zzoq sk;
    private final zzoq sl;
    private RemoteMediaClient pn;
    private CastDevice mg;
    private MediaSessionCompat sm;
    private MediaSessionCompat.Callback sn;
    private boolean so;

    public zzou(Context context, CastOptions castOptions, zzop zzop2) {
        this.zzcfo = context;
        this.si = castOptions;
        this.pK = zzop2;
        this.sj = this.si.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.si.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzcfo, this.si.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.sk = new zzoq(this.zzcfo);
        this.sk.zza(new zzoq.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                bitmap = zzou.zzd(bitmap);
                zzou.this.zza(bitmap, 0);
            }
        });
        this.sl = new zzoq(this.zzcfo);
        this.sl.zza(new zzoq.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                zzou.this.zza(bitmap, 3);
            }
        });
    }

    public static Bitmap zzd(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        int n3 = (int)((float)n * 9.0f / 16.0f + 0.5f);
        float f = (n3 - n2) / 2;
        RectF rectF = new RectF(0.0f, f, (float)n, f + (float)n2);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n, (int)n3, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawBitmap(bitmap, null, rectF, null);
        return bitmap2;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        AudioManager audioManager;
        if (this.so || this.si == null || this.si.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.pn = remoteMediaClient;
        this.pn.addListener(this);
        this.mg = castDevice;
        if (!zzs.zzayx()) {
            audioManager = (AudioManager)this.zzcfo.getSystemService("audio");
            audioManager.requestAudioFocus(null, 3, 3);
        }
        audioManager = new ComponentName(this.zzcfo, this.si.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent((ComponentName)audioManager);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzcfo, (int)0, (Intent)intent, (int)0);
        this.sm = new MediaSessionCompat(this.zzcfo, "CastMediaSession", (ComponentName)audioManager, pendingIntent);
        this.sm.setFlags(3);
        this.zza(0, null);
        if (this.mg != null && !TextUtils.isEmpty((CharSequence)this.mg.getFriendlyName())) {
            this.sm.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzcfo.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.mg.getFriendlyName()})).build());
        }
        this.sn = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zzou.this.pn.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zzou.this.pn.togglePlayback();
            }

            public void onPause() {
                zzou.this.pn.togglePlayback();
            }
        };
        this.sm.setCallback(this.sn);
        this.sm.setActive(true);
        this.pK.setMediaSessionCompat(this.sm);
        this.so = true;
        this.zzany();
    }

    public void zzey(int n) {
        if (!this.so) {
            return;
        }
        this.so = false;
        if (this.pn != null) {
            this.pn.removeListener(this);
        }
        if (!zzs.zzayx()) {
            AudioManager audioManager = (AudioManager)this.zzcfo.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
        this.pK.setMediaSessionCompat(null);
        if (this.sk != null) {
            this.sk.clear();
        }
        if (this.sl != null) {
            this.sl.clear();
        }
        if (this.sm != null) {
            this.sm.setSessionActivity(null);
            this.sm.setCallback(null);
            this.sm.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.sm.setActive(false);
            this.sm.release();
            this.sm = null;
        }
        this.pn = null;
        this.mg = null;
        this.sn = null;
        this.zzaob();
        if (n == 0) {
            this.zzaod();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.sm == null ? null : this.sm.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzany();
    }

    @Override
    public void onStatusUpdated() {
        this.zzany();
    }

    @Override
    public void onMetadataUpdated() {
        this.zzany();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzany();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zzany() {
        MediaStatus mediaStatus = this.pn.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        int n = 0;
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.pn.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.pn.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    if (bl) {
                        mediaInfo = mediaStatus.getQueueItemById(n3).getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzaob();
            this.zzaod();
        } else {
            this.zzaoa();
            if (!bl) {
                this.zzaoc();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.sm.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.sm.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.sm.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.sm.setSessionActivity(this.zzaoe());
            this.zza(mediaInfo);
        }
    }

    private void zza(MediaInfo mediaInfo) {
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zzanz().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        this.sm.setMetadata(builder.build());
        Uri uri = this.zza(mediaMetadata, 0);
        if (uri != null) {
            this.sk.zzo(uri);
        } else {
            this.zza((Bitmap)null, 0);
        }
        Uri uri2 = this.zza(mediaMetadata, 3);
        if (uri2 != null) {
            this.sl.zzo(uri2);
        } else {
            this.zza((Bitmap)null, 3);
        }
    }

    private void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.sm.setMetadata(this.zzanz().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
            } else {
                Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap2.eraseColor(0);
                this.sm.setMetadata(this.zzanz().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            }
        } else if (n == 3) {
            this.sm.setMetadata(this.zzanz().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage = this.si.getCastMediaOptions().getImagePicker() != null ? this.si.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zzanz() {
        MediaMetadataCompat mediaMetadataCompat = this.sm.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zzaoa() {
        if (this.si.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.pn == null) {
            return;
        }
        Intent intent = new Intent(this.zzcfo, MediaNotificationService.class);
        intent.setPackage(this.zzcfo.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.pn.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.pn.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.mg);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.pn.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzcfo.startService(intent);
    }

    private void zzaob() {
        if (this.si.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzcfo, MediaNotificationService.class);
        intent.setPackage(this.zzcfo.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzcfo.stopService(intent);
    }

    private void zzaoc() {
        if (!this.si.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzcfo, ReconnectionService.class);
        intent.setPackage(this.zzcfo.getPackageName());
        this.zzcfo.startService(intent);
    }

    private void zzaod() {
        if (!this.si.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzcfo, ReconnectionService.class);
        intent.setPackage(this.zzcfo.getPackageName());
        this.zzcfo.stopService(intent);
    }

    private PendingIntent zzaoe() {
        if (this.sj == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.sj);
        return PendingIntent.getActivity((Context)this.zzcfo, (int)0, (Intent)intent, (int)0x8000000);
    }
}

