/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.zzd;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzym;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ApplicationMetadata
extends zza {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zzd();
    private final int mVersionCode;
    String zzalR;
    String mName;
    List<WebImage> zzFT;
    List<String> zzalS;
    String zzalT;
    Uri zzalU;

    ApplicationMetadata(int n, String string, String string2, List<WebImage> list, List<String> list2, String string3, Uri uri) {
        this.mVersionCode = n;
        this.zzalR = string;
        this.mName = string2;
        this.zzFT = list;
        this.zzalS = list2;
        this.zzalT = string3;
        this.zzalU = uri;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzFT = new ArrayList<WebImage>();
        this.zzalS = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzalR;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String string) {
        return this.zzalS != null && this.zzalS.contains(string);
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzalS);
    }

    public boolean areNamespacesSupported(List<String> list) {
        return this.zzalS != null && this.zzalS.containsAll(list);
    }

    public String getSenderAppIdentifier() {
        return this.zzalT;
    }

    public Uri zzrI() {
        return this.zzalU;
    }

    public List<WebImage> getImages() {
        return this.zzFT;
    }

    public String toString() {
        return "applicationId: " + this.zzalR + ", name: " + this.mName + ", images.count: " + (this.zzFT == null ? 0 : this.zzFT.size()) + ", namespaces.count: " + (this.zzalS == null ? 0 : this.zzalS.size()) + ", senderAppIdentifier: " + this.zzalT + ", senderAppLaunchUrl: " + this.zzalU;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mVersionCode, this.zzalR, this.mName, this.zzFT, this.zzalS, this.zzalT, this.zzalU});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)((Object)object);
        return zzym.zza(this.zzalR, applicationMetadata.zzalR) && zzym.zza(this.zzFT, applicationMetadata.zzFT) && zzym.zza(this.mName, applicationMetadata.mName) && zzym.zza(this.zzalS, applicationMetadata.zzalS) && zzym.zza(this.zzalT, applicationMetadata.zzalT) && zzym.zza(this.zzalU, applicationMetadata.zzalU);
    }
}

