/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyl;
import com.google.android.gms.internal.zzyq;
import com.google.android.gms.internal.zzyt;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.zza<zzyl, CastOptions> zzahd = new Api.zza<zzyl, CastOptions>(){

        public zzyl zza(Context context, Looper looper, zzg zzg2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((Object)castOptions, (Object)"Setting the API options is required.");
            return new zzyl(context, looper, zzg2, castOptions.zzalZ, castOptions.zzamb, castOptions.zzama, castOptions.extras, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastOptions> API = new Api("Cast.API", zzahd, zzyt.zzavu);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient googleApiClient) throws IOException, IllegalStateException {
                try {
                    ((zzyl)googleApiClient.zza(zzyt.zzavu)).requestStatus();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient googleApiClient, final String string, final String string2) {
                return googleApiClient.zzb((zzzv.zza)new zzyq(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zza(string, string2, (zzzv.zzb<Status>)this);
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzb((zzzv.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zza(string, false, (zzzv.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string, final LaunchOptions launchOptions) {
                return googleApiClient.zzb((zzzv.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zza(string, launchOptions, (zzzv.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, boolean bl) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(bl).build();
                return this.launchApplication(googleApiClient, string, launchOptions);
            }

            public PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, final String string, final String string2, final zzf zzf2) {
                return googleApiClient.zzb((zzzv.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zza(string, string2, zzf2, (zzzv.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string, String string2) {
                return this.zza(googleApiClient, string, string2, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string) {
                return this.zza(googleApiClient, string, null, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient) {
                return this.zza(googleApiClient, null, null, null);
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((zzzv.zza)new zzyq(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zzb((zzzv.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((zzzv.zza)new zzyq(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        try {
                            zzyl2.zza("", (zzzv.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzb((zzzv.zza)new zzyq(this, googleApiClient){

                    @Override
                    public void zza(zzyl zzyl2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            this.zze(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            zzyl2.zza(string, (zzzv.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzch(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient googleApiClient, double d) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zzyl)googleApiClient.zza(zzyt.zzavu)).setVolume(d);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).getVolume();
            }

            @Override
            public void setMute(GoogleApiClient googleApiClient, boolean bl) throws IOException, IllegalStateException {
                try {
                    ((zzyl)googleApiClient.zza(zzyt.zzavu)).setMute(bl);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).isMute();
            }

            @Override
            public int getActiveInputState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).getActiveInputState();
            }

            @Override
            public int getStandbyState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).getStandbyState();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyl)googleApiClient.zza(zzyt.zzavu)).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string, MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
                try {
                    ((zzyl)googleApiClient.zza(zzyt.zzavu)).setMessageReceivedCallbacks(string, messageReceivedCallback);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string) throws IOException, IllegalArgumentException {
                try {
                    ((zzyl)googleApiClient.zza(zzyt.zzavu)).removeMessageReceivedCallbacks(string);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    static abstract class zza
    extends zzyi<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public ApplicationConnectionResult zzo(final Status status) {
            return new ApplicationConnectionResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        public void zza(zzyl zzyl2) throws RemoteException {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzo(status);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzalZ;
        final Listener zzama;
        final Bundle extras;
        private final int zzamb;

        private CastOptions(Builder builder) {
            this.zzalZ = builder.zzamc;
            this.zzama = builder.zzamd;
            this.zzamb = builder.zzame;
            this.extras = builder.mExtras;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener listener) {
            return new Builder(castDevice, listener);
        }

        public static final class Builder {
            CastDevice zzamc;
            Listener zzamd;
            private int zzame;
            private Bundle mExtras;

            public Builder(CastDevice castDevice, Listener listener) {
                zzac.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                zzac.zzb((Object)listener, (Object)"CastListener parameter cannot be null");
                this.zzamc = castDevice;
                this.zzamd = listener;
                this.zzame = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean bl) {
                this.zzame = bl ? (this.zzame |= 1) : (this.zzame &= 0xFFFFFFFE);
                return this;
            }

            public Builder zzk(Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onActiveInputStateChanged(int n) {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

