/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyl;
import com.google.android.gms.internal.zzyv;
import com.google.android.gms.internal.zzyw;
import com.google.android.gms.internal.zzyx;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

@SuppressLint(value={"MissingRemoteException"})
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzrN = new Object();
    private final zzyv zzanU;
    private final zza zzanV;
    private OnPreloadStatusUpdatedListener zzanW;
    private OnQueueStatusUpdatedListener zzanX;
    private OnMetadataUpdatedListener zzanY;
    private OnStatusUpdatedListener zzanZ;
    public static final String NAMESPACE = zzyv.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this(new zzyv(null));
    }

    RemoteMediaPlayer(zzyv zzyv2) {
        this.zzanU = zzyv2;
        this.zzanU.zza(new zzyv.zza(){

            @Override
            public void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            public void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            public void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            public void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }

            @Override
            public void onAdBreakStatusUpdated() {
            }
        });
        this.zzanV = new zza();
        this.zzanU.zza(this.zzanV);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo) {
        return this.load(googleApiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl) {
        return this.load(googleApiClient, mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient googleApiClient, final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient googleApiClient) {
        return this.pause(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient googleApiClient) {
        return this.stop(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zzb(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient googleApiClient) {
        return this.play(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zzc(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l) {
        return this.seek(googleApiClient, l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l, int n) {
        return this.seek(googleApiClient, l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient googleApiClient, final long l, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, l, n, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient googleApiClient, double d) throws IllegalArgumentException {
        return this.setStreamVolume(googleApiClient, d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient googleApiClient, final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, d, jSONObject);
                    }
                    catch (zzyv.zzb | IOException | IllegalArgumentException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient googleApiClient, boolean bl) {
        return this.setStreamMute(googleApiClient, bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient googleApiClient, final boolean bl, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, bl, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient googleApiClient, final long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, lArray);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient googleApiClient, final TextTrackStyle textTrackStyle) {
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, textTrackStyle);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient googleApiClient, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(googleApiClient, mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(googleApiClient, new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(googleApiClient, mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient googleApiClient, final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient googleApiClient, final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, nArray, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient googleApiClient, final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, nArray, n, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, 0, -1L, null, 0, (Integer)n, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbR(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, new int[]{n}, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient googleApiClient, int n, JSONObject jSONObject) {
        return this.queueJumpToItem(googleApiClient, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient googleApiClient, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbR(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, n, l, null, 0, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient googleApiClient, final int n, final int n2, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaPlayer.this.zzrN;
                synchronized (object) {
                    int n4 = RemoteMediaPlayer.this.zzbR(n);
                    if (n4 == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzanV.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzanU.zza(this.zzaoC, new int[]{n}, n3, jSONObject);
                    }
                    catch (zzyv.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzanV.zzc(null);
                    }
                }
            }
        });
    }

    private int zzbR(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzanU.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzanU.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzanU.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzrN;
        synchronized (object) {
            return this.zzanU.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener onStatusUpdatedListener) {
        this.zzanZ = onStatusUpdatedListener;
    }

    private void onStatusUpdated() {
        if (this.zzanZ != null) {
            this.zzanZ.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener onMetadataUpdatedListener) {
        this.zzanY = onMetadataUpdatedListener;
    }

    private void onMetadataUpdated() {
        if (this.zzanY != null) {
            this.zzanY.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener onQueueStatusUpdatedListener) {
        this.zzanX = onQueueStatusUpdatedListener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzanX != null) {
            this.zzanX.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener onPreloadStatusUpdatedListener) {
        this.zzanW = onPreloadStatusUpdatedListener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzanW != null) {
            this.zzanW.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzanU.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzanU.zzcO(string3);
    }

    static abstract class zzb
    extends zzyi<MediaChannelResult> {
        zzyx zzaoC = new zzyx(){

            @Override
            public void zzC(long l) {
                zzb.this.zzb((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzq(final Status status) {
            return new MediaChannelResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zzyl zzyl2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzahq;
        private final JSONObject zzalI;

        zzc(Status status, JSONObject jSONObject) {
            this.zzahq = status;
            this.zzalI = jSONObject;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzalI;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzyw {
        private GoogleApiClient zzaoy;
        private long zzaoz = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzaoy = googleApiClient;
        }

        @Override
        public long zzsc() {
            return ++this.zzaoz;
        }

        @Override
        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzaoy == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzaoy, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzaoA;

            zza(long l) {
                this.zzaoA = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzanU.zzb(this.zzaoA, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

