/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzi;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzym;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo
extends zza
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzi();
    private final int mVersionCode;
    private final String zzanb;
    private int zzanc;
    private String zzand;
    private MediaMetadata zzane;
    private long zzanf;
    private List<MediaTrack> zzang;
    private TextTrackStyle zzanh;
    String zzalH;
    private List<AdBreakInfo> zzani;
    private List<AdBreakClipInfo> zzanj;
    private JSONObject zzalI;

    MediaInfo(int n, String string2, int n2, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.mVersionCode = n;
        this.zzanb = string2;
        this.zzanc = n2;
        this.zzand = string3;
        this.zzane = mediaMetadata;
        this.zzanf = l;
        this.zzang = list;
        this.zzanh = textTrackStyle;
        this.zzalH = string4;
        if (this.zzalH != null) {
            try {
                this.zzalI = new JSONObject(this.zzalH);
            }
            catch (JSONException jSONException) {
                this.zzalI = null;
                this.zzalH = null;
            }
        } else {
            this.zzalI = null;
        }
        this.zzani = list2;
        this.zzanj = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(2, string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(2, jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        Object object;
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzanc = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzand = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzane = new MediaMetadata(n);
            this.zzane.zzn(jSONObject2);
        }
        this.zzanf = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzanf = zzym.zzf(d);
        }
        if (jSONObject.has("tracks")) {
            this.zzang = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                object = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack((JSONObject)object);
                this.zzang.add(mediaTrack);
            }
        } else {
            this.zzang = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzn(jSONObject2);
            this.zzanh = textTrackStyle;
        } else {
            this.zzanh = null;
        }
        if (jSONObject.has("breaks")) {
            jSONObject2 = jSONObject.getJSONArray("breaks");
            this.zzani = new ArrayList<AdBreakInfo>(jSONObject2.length());
            for (int i = 0; i < jSONObject2.length(); ++i) {
                object = AdBreakInfo.zzl(jSONObject2.getJSONObject(i));
                if (object == null) {
                    this.zzani.clear();
                    break;
                }
                this.zzani.add((AdBreakInfo)((Object)object));
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONObject2 = jSONObject.getJSONArray("breakClips");
            this.zzanj = new ArrayList<AdBreakClipInfo>(jSONObject2.length());
            for (int i = 0; i < jSONObject2.length(); ++i) {
                object = AdBreakClipInfo.zzk(jSONObject2.getJSONObject(i));
                if (object == null) {
                    this.zzanj.clear();
                    break;
                }
                this.zzanj.add((AdBreakClipInfo)((Object)object));
            }
        }
        this.zzalI = jSONObject.optJSONObject("customData");
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getContentId() {
        return this.zzanb;
    }

    void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzanc = n;
    }

    public int getStreamType() {
        return this.zzanc;
    }

    void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzand = string2;
    }

    public String getContentType() {
        return this.zzand;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzane = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzane;
    }

    void zzB(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzanf = l;
    }

    public long getStreamDuration() {
        return this.zzanf;
    }

    void zzx(List<MediaTrack> list) {
        this.zzang = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzang;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzanh = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzanh;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzalI = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzalI;
    }

    public List<AdBreakInfo> getAdBreaks() {
        return this.zzani == null ? null : Collections.unmodifiableList(this.zzani);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        return this.zzanj == null ? null : Collections.unmodifiableList(this.zzanj);
    }

    public void zzy(List<AdBreakInfo> list) {
        this.zzani = list;
    }

    private void zzrZ() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzanb)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzand)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzanc == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzanb);
            switch (this.zzanc) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzand != null) {
                jSONObject.put("contentType", (Object)this.zzand);
            }
            if (this.zzane != null) {
                jSONObject.put("metadata", (Object)this.zzane.toJson());
            }
            if (this.zzanf <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzym.zzF(this.zzanf));
            }
            if (this.zzang != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzang) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzanh != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzanh.toJson());
            }
            if (this.zzalI != null) {
                jSONObject.put("customData", (Object)this.zzalI);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzalI == null != (mediaInfo.zzalI == null)) {
            return false;
        }
        if (this.zzalI != null && mediaInfo.zzalI != null && !zzp.zzf((Object)this.zzalI, (Object)mediaInfo.zzalI)) {
            return false;
        }
        return zzym.zza(this.zzanb, mediaInfo.zzanb) && this.zzanc == mediaInfo.zzanc && zzym.zza(this.zzand, mediaInfo.zzand) && zzym.zza(this.zzane, mediaInfo.zzane) && this.zzanf == mediaInfo.zzanf && zzym.zza(this.zzang, mediaInfo.zzang) && zzym.zza(this.zzanh, mediaInfo.zzanh) && zzym.zza(this.zzani, mediaInfo.zzani) && zzym.zza(this.zzanj, mediaInfo.zzanj);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzanb, this.zzanc, this.zzand, this.zzane, this.zzanf, String.valueOf(this.zzalI), this.zzang, this.zzanh, this.zzani, this.zzanj});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzalH = this.zzalI == null ? null : this.zzalI.toString();
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaInfo zzank;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzank = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzank.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzank.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzank.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzank.zzB(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzank.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzank.zzx(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzank.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzank.zzrZ();
            return this.zzank;
        }
    }
}

