/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzj;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzyz;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zzanl = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzanm;
    public static final Parcelable.Creator<MediaMetadata> CREATOR;
    private final int mVersionCode;
    private final List<WebImage> zzFT;
    final Bundle zzann;
    private int zzano;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    MediaMetadata(int n, List<WebImage> list, Bundle bundle, int n2) {
        this.mVersionCode = n;
        this.zzFT = list;
        this.zzann = bundle;
        this.zzano = n2;
    }

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int n) {
        this(1, new ArrayList<WebImage>(), new Bundle(), n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int getMediaType() {
        return this.zzano;
    }

    public void clear() {
        this.zzann.clear();
        this.zzFT.clear();
    }

    public boolean containsKey(String string2) {
        return this.zzann.containsKey(string2);
    }

    public Set<String> keySet() {
        return this.zzann.keySet();
    }

    public void putString(String string2, String string3) {
        this.zzg(string2, 1);
        this.zzann.putString(string2, string3);
    }

    public String getString(String string2) {
        this.zzg(string2, 1);
        return this.zzann.getString(string2);
    }

    public void putInt(String string2, int n) {
        this.zzg(string2, 2);
        this.zzann.putInt(string2, n);
    }

    public int getInt(String string2) {
        this.zzg(string2, 2);
        return this.zzann.getInt(string2);
    }

    public void putDouble(String string2, double d) {
        this.zzg(string2, 3);
        this.zzann.putDouble(string2, d);
    }

    public double getDouble(String string2) {
        this.zzg(string2, 3);
        return this.zzann.getDouble(string2);
    }

    public void putDate(String string2, Calendar calendar) {
        this.zzg(string2, 4);
        this.zzann.putString(string2, zzyz.zza(calendar));
    }

    public Calendar getDate(String string2) {
        this.zzg(string2, 4);
        String string3 = this.zzann.getString(string2);
        return string3 != null ? zzyz.zzcV(string3) : null;
    }

    public String getDateAsString(String string2) {
        this.zzg(string2, 4);
        return this.zzann.getString(string2);
    }

    private void zzg(String string2, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzanm.zzcH(string2);
        if (n2 != n && n2 != 0) {
            String string3 = String.valueOf(zzanl[n]);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Value for ").append(string2).append(" must be a ").append(string3).toString());
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zzano);
        }
        catch (JSONException jSONException) {}
        zzyz.zza(jSONObject, this.zzFT);
        switch (this.zzano) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void zzn(JSONObject jSONObject) {
        this.clear();
        this.zzano = 0;
        try {
            this.zzano = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {}
        zzyz.zza(this.zzFT, jSONObject);
        switch (this.zzano) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zzb(jSONObject, new String[0]);
            }
        }
    }

    private void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string2 : stringArray) {
                if (!this.zzann.containsKey(string2)) continue;
                int n = zzanm.zzcH(string2);
                switch (n) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzanm.zzcF(string2), (Object)this.zzann.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzanm.zzcF(string2), this.zzann.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzanm.zzcF(string2), this.zzann.getDouble(string2));
                    }
                }
            }
            for (String string3 : this.zzann.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.zzann.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
        }
        catch (JSONException jSONException) {}
    }

    private void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = zzanm.zzcG(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (zzanm.zzcH(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzann.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = zzyz.zzcV((String)object);
                                if (calendar == null) continue block10;
                                this.zzann.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzann.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzann.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.zzann.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzann.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzann.putDouble(string2, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {}
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)((Object)object);
        return this.zzb(this.zzann, mediaMetadata.zzann) && this.zzFT.equals(mediaMetadata.zzFT);
    }

    public int hashCode() {
        int n = 17;
        Set set = this.zzann.keySet();
        for (String string2 : set) {
            n = 31 * n + this.zzann.get(string2).hashCode();
        }
        n = 31 * n + this.zzFT.hashCode();
        return n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public List<WebImage> getImages() {
        return this.zzFT;
    }

    public boolean hasImages() {
        return this.zzFT != null && !this.zzFT.isEmpty();
    }

    public void clearImages() {
        this.zzFT.clear();
    }

    public void addImage(WebImage webImage) {
        this.zzFT.add(webImage);
    }

    private boolean zzb(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string2 : set) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zzb((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    static {
        CREATOR = new zzj();
        zzanm = new zza().zzc(KEY_CREATION_DATE, "creationDateTime", 4).zzc(KEY_RELEASE_DATE, "releaseDate", 4).zzc(KEY_BROADCAST_DATE, "originalAirdate", 4).zzc(KEY_TITLE, "title", 1).zzc(KEY_SUBTITLE, "subtitle", 1).zzc(KEY_ARTIST, "artist", 1).zzc(KEY_ALBUM_ARTIST, "albumArtist", 1).zzc(KEY_ALBUM_TITLE, "albumName", 1).zzc(KEY_COMPOSER, "composer", 1).zzc(KEY_DISC_NUMBER, "discNumber", 2).zzc(KEY_TRACK_NUMBER, "trackNumber", 2).zzc(KEY_SEASON_NUMBER, "season", 2).zzc(KEY_EPISODE_NUMBER, "episode", 2).zzc(KEY_SERIES_TITLE, "seriesTitle", 1).zzc(KEY_STUDIO, "studio", 1).zzc(KEY_WIDTH, "width", 2).zzc(KEY_HEIGHT, "height", 2).zzc(KEY_LOCATION_NAME, "location", 1).zzc(KEY_LOCATION_LATITUDE, "latitude", 3).zzc(KEY_LOCATION_LONGITUDE, "longitude", 3);
    }

    private static class zza {
        private final Map<String, String> zzanp = new HashMap<String, String>();
        private final Map<String, String> zzanq = new HashMap<String, String>();
        private final Map<String, Integer> zzanr = new HashMap<String, Integer>();

        public zza zzc(String string2, String string3, int n) {
            this.zzanp.put(string2, string3);
            this.zzanq.put(string3, string2);
            this.zzanr.put(string2, n);
            return this;
        }

        public String zzcF(String string2) {
            return this.zzanp.get(string2);
        }

        public String zzcG(String string2) {
            return this.zzanq.get(string2);
        }

        public int zzcH(String string2) {
            Integer n = this.zzanr.get(string2);
            return n != null ? n : 0;
        }
    }
}

