/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzym;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zzyd
implements GameManagerState {
    private final int zzauC;
    private final int zzauB;
    private final String zzauF;
    private final JSONObject zzauE;
    private final String zzauv;
    private final int zzauw;
    private final Map<String, PlayerInfo> zzauH;

    public zzyd(int n, int n2, String string2, JSONObject jSONObject, Collection<PlayerInfo> collection, String string3, int n3) {
        this.zzauC = n;
        this.zzauB = n2;
        this.zzauF = string2;
        this.zzauE = jSONObject;
        this.zzauv = string3;
        this.zzauw = n3;
        this.zzauH = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzauH.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public int getLobbyState() {
        return this.zzauC;
    }

    @Override
    public int getGameplayState() {
        return this.zzauB;
    }

    @Override
    public JSONObject getGameData() {
        return this.zzauE;
    }

    @Override
    public CharSequence getGameStatusText() {
        return this.zzauF;
    }

    @Override
    public CharSequence getApplicationName() {
        return this.zzauv;
    }

    @Override
    public int getMaxPlayers() {
        return this.zzauw;
    }

    @Override
    public List<PlayerInfo> getPlayersInState(int n) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != n) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public PlayerInfo getPlayer(String string2) {
        return string2 == null ? null : this.zzauH.get(string2);
    }

    @Override
    public Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzauH.values());
    }

    @Override
    public List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public boolean hasLobbyStateChanged(GameManagerState gameManagerState) {
        return this.zzauC != gameManagerState.getLobbyState();
    }

    @Override
    public boolean hasGameplayStateChanged(GameManagerState gameManagerState) {
        return this.zzauB != gameManagerState.getGameplayState();
    }

    @Override
    public boolean hasGameDataChanged(GameManagerState gameManagerState) {
        return !zzp.zzf((Object)this.zzauE, (Object)gameManagerState.getGameData());
    }

    @Override
    public boolean hasGameStatusTextChanged(GameManagerState gameManagerState) {
        return !zzym.zza(this.zzauF, gameManagerState.getGameStatusText());
    }

    @Override
    public boolean hasPlayerChanged(String string2, GameManagerState gameManagerState) {
        return !zzym.zza(this.getPlayer(string2), gameManagerState.getPlayer(string2));
    }

    @Override
    public boolean hasPlayerStateChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public boolean hasPlayerDataChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zzp.zzf((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public Collection<String> getListOfChangedPlayers(GameManagerState gameManagerState) {
        PlayerInfo playerInfo;
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo2 : this.getPlayers()) {
            playerInfo = gameManagerState.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null && playerInfo2.equals(playerInfo)) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
            playerInfo = this.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)object;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzym.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzym.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzauC == gameManagerState.getLobbyState() && this.zzauB == gameManagerState.getGameplayState() && this.zzauw == gameManagerState.getMaxPlayers() && zzym.zza(this.zzauv, gameManagerState.getApplicationName()) && zzym.zza(this.zzauF, gameManagerState.getGameStatusText()) && zzp.zzf((Object)this.zzauE, (Object)gameManagerState.getGameData());
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzauC, this.zzauB, this.zzauH, this.zzauF, this.zzauE, this.zzauv, this.zzauw});
    }
}

