/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzyj;
import com.google.android.gms.internal.zzym;
import com.google.android.gms.internal.zzyx;
import com.google.android.gms.internal.zzyy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzyv
extends zzyj {
    public static final String NAMESPACE = zzym.zzcQ("com.google.cast.media");
    private long zzavF;
    private MediaStatus zzavG;
    private final List<zzyy> zzatX;
    private zza zzavH;
    private final zzyy zzavI;
    private final zzyy zzavJ;
    private final zzyy zzavK;
    private final zzyy zzavL;
    private final zzyy zzavM;
    private final zzyy zzavN;
    private final zzyy zzavO;
    private final zzyy zzavP;
    private final zzyy zzavQ;
    private final zzyy zzavR;
    private final zzyy zzavS;
    private final zzyy zzavT;
    private final zzyy zzavU;
    private final zzyy zzavV;

    public zzyv(String string2) {
        super(NAMESPACE, zzh.zzyv(), "MediaControlChannel", string2, 1000L);
        this.zzavI = new zzyy(this.zzuI, 86400000L);
        this.zzavJ = new zzyy(this.zzuI, 86400000L);
        this.zzavK = new zzyy(this.zzuI, 86400000L);
        this.zzavL = new zzyy(this.zzuI, 86400000L);
        this.zzavM = new zzyy(this.zzuI, 86400000L);
        this.zzavN = new zzyy(this.zzuI, 86400000L);
        this.zzavO = new zzyy(this.zzuI, 86400000L);
        this.zzavP = new zzyy(this.zzuI, 86400000L);
        this.zzavQ = new zzyy(this.zzuI, 86400000L);
        this.zzavR = new zzyy(this.zzuI, 86400000L);
        this.zzavS = new zzyy(this.zzuI, 86400000L);
        this.zzavT = new zzyy(this.zzuI, 86400000L);
        this.zzavU = new zzyy(this.zzuI, 86400000L);
        this.zzavV = new zzyy(this.zzuI, 86400000L);
        this.zzatX = new ArrayList<zzyy>();
        this.zzatX.add(this.zzavI);
        this.zzatX.add(this.zzavJ);
        this.zzatX.add(this.zzavK);
        this.zzatX.add(this.zzavL);
        this.zzatX.add(this.zzavM);
        this.zzatX.add(this.zzavN);
        this.zzatX.add(this.zzavO);
        this.zzatX.add(this.zzavP);
        this.zzatX.add(this.zzavQ);
        this.zzatX.add(this.zzavR);
        this.zzatX.add(this.zzavS);
        this.zzatX.add(this.zzavT);
        this.zzatX.add(this.zzavU);
        this.zzatX.add(this.zzavV);
        this.zzuo();
    }

    public void zza(zza zza2) {
        this.zzavH = zza2;
    }

    public long zza(zzyx zzyx2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzub();
        this.zzavI.zza(l2, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzym.zzF(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzyx zzyx2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavJ.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzsa());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzyx zzyx2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavL.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzsa());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzyx zzyx2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavK.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzsa());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2, long l, int n, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzub();
        this.zzavM.zza(l2, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzsa());
            jSONObject2.put("currentTime", zzym.zzF(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzyx zzyx2, double d, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavN.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzsa());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2, boolean bl, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavO.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzsa());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzub();
        this.zzavP.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzavG != null) {
                jSONObject.put("mediaSessionId", this.zzavG.zzsa());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2, long[] lArray) throws IOException, zzb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzub();
        this.zzavQ.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzsa());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2, TextTrackStyle textTrackStyle) throws IOException, zzb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzub();
        this.zzavR.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzsa());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzavF == 0L) {
            return 0L;
        }
        double d = this.zzavG.getPlaybackRate();
        long l = this.zzavG.getStreamPosition();
        int n = this.zzavG.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        return this.zza(d, l, mediaInfo.getStreamDuration());
    }

    private long zza(double d, long l, long l2) {
        long l3 = this.zzuI.elapsedRealtime() - this.zzavF;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzavG;
    }

    public MediaInfo getMediaInfo() {
        return this.zzavG == null ? null : this.zzavG.getMediaInfo();
    }

    public long zza(zzyx zzyx2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzub();
        this.zzavI.zza(l2, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", zzym.zzF(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzyx zzyx2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n2 != 0 && n3 != -1) {
            throw new IllegalArgumentException("can not set both currentItemId and currentItemIndexInItemsToInsert");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzub();
        this.zzavS.zza(l2, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzsa());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n2 != 0) {
                jSONObject2.put("currentItemId", n2);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzym.zzF(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzyx zzyx2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzb {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzub();
        this.zzavT.zza(l2, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzsa());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzym.zzF(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzyx zzyx2, int[] nArray, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavU.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzsa());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzyx zzyx2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzub();
        this.zzavV.zza(l, zzyx2);
        this.zzao(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzsa());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzcO(String string2) {
        this.zzaoQ.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        break;
                    }
                    this.zzavG = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzavP.zzc(l, 0);
                    break;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzaoQ.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    for (zzyy zzyy2 : this.zzatX) {
                        zzyy2.zzc(l, 2100, jSONObject2);
                    }
                    break;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzavI.zzc(l, 2100, jSONObject3);
                    break;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzavI.zzc(l, 2101, jSONObject4);
                    break;
                }
                case "INVALID_REQUEST": {
                    this.zzaoQ.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    for (zzyy zzyy3 : this.zzatX) {
                        zzyy3.zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzaoQ.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzavI.test(l);
        boolean bl2 = this.zzavM.zzuq() && !this.zzavM.test(l);
        boolean bl3 = this.zzavN.zzuq() && !this.zzavN.test(l) || this.zzavO.zzuq() && !this.zzavO.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzavG == null) {
            this.zzavG = new MediaStatus(jSONObject);
            this.zzavF = this.zzuI.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzavG.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzavF = this.zzuI.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzavF = this.zzuI.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzavF = this.zzuI.elapsedRealtime();
            this.onAdBreakStatusUpdated();
        }
        if ((n & 0x40) != 0) {
            this.zzavF = this.zzuI.elapsedRealtime();
            this.onStatusUpdated();
        }
        for (zzyy zzyy2 : this.zzatX) {
            zzyy2.zzc(l, 0);
        }
    }

    public long zzsa() throws zzb {
        if (this.zzavG == null) {
            throw new zzb();
        }
        return this.zzavG.zzsa();
    }

    private void onStatusUpdated() {
        if (this.zzavH != null) {
            this.zzavH.onStatusUpdated();
        }
    }

    private void onMetadataUpdated() {
        if (this.zzavH != null) {
            this.zzavH.onMetadataUpdated();
        }
    }

    private void onQueueStatusUpdated() {
        if (this.zzavH != null) {
            this.zzavH.onQueueStatusUpdated();
        }
    }

    private void onPreloadStatusUpdated() {
        if (this.zzavH != null) {
            this.zzavH.onPreloadStatusUpdated();
        }
    }

    private void onAdBreakStatusUpdated() {
        if (this.zzavH != null) {
            this.zzavH.onAdBreakStatusUpdated();
        }
    }

    private void zzuo() {
        this.zzavF = 0L;
        this.zzavG = null;
        for (zzyy zzyy2 : this.zzatX) {
            zzyy2.clear();
        }
    }

    @Override
    public void zzua() {
        super.zzua();
        this.zzuo();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzyy zzyy2 : this.zzatX) {
            zzyy2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzE(long l) {
        for (zzyy object2 : this.zzatX) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzyy.zzqW;
        synchronized (object) {
            for (zzyy zzyy2 : this.zzatX) {
                if (!zzyy2.zzuq()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static class zzb
    extends Exception {
    }

    public static interface zza {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onAdBreakStatusUpdated();
    }
}

