/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyq;
import com.google.android.gms.internal.zzza;
import com.google.android.gms.internal.zzzb;
import com.google.android.gms.internal.zzzc;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

@SuppressLint(value={"MissingRemoteException"})
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzrJ = new Object();
    private final zzza zzaoZ;
    private final zza zzapa;
    private OnPreloadStatusUpdatedListener zzapb;
    private OnQueueStatusUpdatedListener zzapc;
    private OnMetadataUpdatedListener zzapd;
    private OnStatusUpdatedListener zzape;
    public static final String NAMESPACE = zzza.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this(new zzza(null));
    }

    RemoteMediaPlayer(zzza zzza2) {
        this.zzaoZ = zzza2;
        this.zzaoZ.zza(new zzza.zza(){

            @Override
            public void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            public void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            public void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            public void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }

            @Override
            public void onAdBreakStatusUpdated() {
            }
        });
        this.zzapa = new zza();
        this.zzaoZ.zza(this.zzapa);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo) {
        return this.load(googleApiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl) {
        return this.load(googleApiClient, mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient googleApiClient, MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(googleApiClient, mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient googleApiClient, final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient googleApiClient) {
        return this.pause(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient googleApiClient) {
        return this.stop(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zzb(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient googleApiClient) {
        return this.play(googleApiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zzc(this.zzapH, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l) {
        return this.seek(googleApiClient, l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient googleApiClient, long l, int n) {
        return this.seek(googleApiClient, l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient googleApiClient, final long l, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, l, n, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient googleApiClient, double d) throws IllegalArgumentException {
        return this.setStreamVolume(googleApiClient, d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient googleApiClient, final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, d, jSONObject);
                    }
                    catch (zzza.zzb | IOException | IllegalArgumentException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient googleApiClient, boolean bl) {
        return this.setStreamMute(googleApiClient, bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient googleApiClient, final boolean bl, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, bl, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient googleApiClient, final long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, lArray);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient googleApiClient, final TextTrackStyle textTrackStyle) {
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, textTrackStyle);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient googleApiClient, MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(googleApiClient, mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(googleApiClient, new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient googleApiClient, MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(googleApiClient, mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient googleApiClient, final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient googleApiClient, final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient googleApiClient, final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, nArray, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient googleApiClient, final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, nArray, n, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient googleApiClient, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, 0, -1L, null, 0, (Integer)n, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient googleApiClient, final int n, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbU(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, new int[]{n}, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient googleApiClient, int n, JSONObject jSONObject) {
        return this.queueJumpToItem(googleApiClient, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient googleApiClient, final int n, final long l, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbU(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, n, l, null, 0, null, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient googleApiClient, final int n, final int n2, final JSONObject jSONObject) {
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyq zzyq2) {
                Object object = RemoteMediaPlayer.this.zzrJ;
                synchronized (object) {
                    int n4 = RemoteMediaPlayer.this.zzbU(n);
                    if (n4 == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzapa.zzc(googleApiClient);
                    try {
                        RemoteMediaPlayer.this.zzaoZ.zza(this.zzapH, new int[]{n}, n3, jSONObject);
                    }
                    catch (zzza.zzb | IOException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzapa.zzc(null);
                    }
                }
            }
        });
    }

    private int zzbU(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaoZ.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaoZ.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaoZ.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaoZ.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener onStatusUpdatedListener) {
        this.zzape = onStatusUpdatedListener;
    }

    private void onStatusUpdated() {
        if (this.zzape != null) {
            this.zzape.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener onMetadataUpdatedListener) {
        this.zzapd = onMetadataUpdatedListener;
    }

    private void onMetadataUpdated() {
        if (this.zzapd != null) {
            this.zzapd.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener onQueueStatusUpdatedListener) {
        this.zzapc = onQueueStatusUpdatedListener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzapc != null) {
            this.zzapc.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener onPreloadStatusUpdatedListener) {
        this.zzapb = onPreloadStatusUpdatedListener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzapb != null) {
            this.zzapb.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzaoZ.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzaoZ.zzcP(string3);
    }

    static abstract class zzb
    extends zzyn<MediaChannelResult> {
        zzzc zzapH = new zzzc(){

            @Override
            public void zzD(long l) {
                zzb.this.zzb((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzq(final Status status) {
            return new MediaChannelResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zzyq zzyq2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzair;
        private final JSONObject zzamO;

        zzc(Status status, JSONObject jSONObject) {
            this.zzair = status;
            this.zzamO = jSONObject;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzamO;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzzb {
        private GoogleApiClient zzapD;
        private long zzapE = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzapD = googleApiClient;
        }

        @Override
        public long zzsA() {
            return ++this.zzapE;
        }

        @Override
        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzapD == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzapD, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzapF;

            zza(long l) {
                this.zzapF = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzaoZ.zzb(this.zzapF, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

