/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzyr;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zza {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzn();
    private float zzapJ;
    private int zzapK;
    private int mBackgroundColor;
    private int zzapL;
    private int zzapM;
    private int zzapN;
    private int zzapO;
    private int zzapP;
    private String zzapQ;
    private int zzapR;
    private int zzapS;
    String zzamN;
    private JSONObject zzamO;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzapJ = f;
        this.zzapK = n;
        this.mBackgroundColor = n2;
        this.zzapL = n3;
        this.zzapM = n4;
        this.zzapN = n5;
        this.zzapO = n6;
        this.zzapP = n7;
        this.zzapQ = string2;
        this.zzapR = n8;
        this.zzapS = n9;
        this.zzamN = string3;
        if (this.zzamN != null) {
            try {
                this.zzamO = new JSONObject(this.zzamN);
            }
            catch (JSONException jSONException) {
                this.zzamO = null;
                this.zzamN = null;
            }
        } else {
            this.zzamO = null;
        }
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public void setFontScale(float f) {
        this.zzapJ = f;
    }

    public float getFontScale() {
        return this.zzapJ;
    }

    public void setForegroundColor(int n) {
        this.zzapK = n;
    }

    public int getForegroundColor() {
        return this.zzapK;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzapL = n;
    }

    public int getEdgeType() {
        return this.zzapL;
    }

    public void setEdgeColor(int n) {
        this.zzapM = n;
    }

    public int getEdgeColor() {
        return this.zzapM;
    }

    public void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzapN = n;
    }

    public int getWindowType() {
        return this.zzapN;
    }

    public void setWindowColor(int n) {
        this.zzapO = n;
    }

    public int getWindowColor() {
        return this.zzapO;
    }

    public void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzapP = n;
    }

    public int getWindowCornerRadius() {
        return this.zzapP;
    }

    public void setFontFamily(String string2) {
        this.zzapQ = string2;
    }

    public String getFontFamily() {
        return this.zzapQ;
    }

    public void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzapR = n;
    }

    public int getFontGenericFamily() {
        return this.zzapR;
    }

    public void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzapS = n;
    }

    public int getFontStyle() {
        return this.zzapS;
    }

    public void setCustomData(JSONObject jSONObject) {
        this.zzamO = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzamO;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzt.zzzl()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzn(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzapJ = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzapK = this.zzcJ(jSONObject.optString("foregroundColor"));
        this.mBackgroundColor = this.zzcJ(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzapL = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzapL = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzapL = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzapL = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzapL = 4;
            }
        }
        this.zzapM = this.zzcJ(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzapN = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzapN = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzapN = 2;
            }
        }
        this.zzapO = this.zzcJ(jSONObject.optString("windowColor"));
        if (this.zzapN == 2) {
            this.zzapP = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzapQ = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzapR = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzapR = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzapR = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzapR = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzapR = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzapR = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzapR = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzapS = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzapS = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzapS = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzapS = 3;
            }
        }
        this.zzamO = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzapJ);
            if (this.zzapK != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzab(this.zzapK));
            }
            if (this.mBackgroundColor != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzab(this.mBackgroundColor));
            }
            switch (this.zzapL) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzapM != 0) {
                jSONObject.put("edgeColor", (Object)this.zzab(this.zzapM));
            }
            switch (this.zzapN) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzapO != 0) {
                jSONObject.put("windowColor", (Object)this.zzab(this.zzapO));
            }
            if (this.zzapN == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzapP);
            }
            if (this.zzapQ != null) {
                jSONObject.put("fontFamily", (Object)this.zzapQ);
            }
            switch (this.zzapR) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzapS) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzamO != null) {
                jSONObject.put("customData", (Object)this.zzamO);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private String zzab(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzcJ(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzamO == null != (textTrackStyle.zzamO == null)) {
            return false;
        }
        if (this.zzamO != null && textTrackStyle.zzamO != null && !zzq.zze((Object)this.zzamO, (Object)textTrackStyle.zzamO)) {
            return false;
        }
        return this.zzapJ == textTrackStyle.zzapJ && this.zzapK == textTrackStyle.zzapK && this.mBackgroundColor == textTrackStyle.mBackgroundColor && this.zzapL == textTrackStyle.zzapL && this.zzapM == textTrackStyle.zzapM && this.zzapN == textTrackStyle.zzapN && this.zzapP == textTrackStyle.zzapP && zzyr.zza(this.zzapQ, textTrackStyle.zzapQ) && this.zzapR == textTrackStyle.zzapR && this.zzapS == textTrackStyle.zzapS;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.zzapJ), this.zzapK, this.mBackgroundColor, this.zzapL, this.zzapM, this.zzapN, this.zzapO, this.zzapP, this.zzapQ, this.zzapR, this.zzapS, String.valueOf(this.zzamO)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzamN = this.zzamO == null ? null : this.zzamO.toString();
        zzn.zza(this, parcel, n);
    }
}

