/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.view.Display;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzyu;
import com.google.android.gms.internal.zzyy;
import com.google.android.gms.internal.zzzf;
import com.google.android.gms.internal.zzzg;

public final class CastRemoteDisplay {
    public static final int CONFIGURATION_INTERACTIVE_REALTIME = 1;
    public static final int CONFIGURATION_INTERACTIVE_NONREALTIME = 2;
    public static final int CONFIGURATION_NONINTERACTIVE = 3;
    private static final Api.zza<zzzg, CastRemoteDisplayOptions> zzaie = new Api.zza<zzzg, CastRemoteDisplayOptions>(){

        public zzzg zza(Context context, Looper looper, zzg zzg2, CastRemoteDisplayOptions castRemoteDisplayOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            Bundle bundle = new Bundle();
            bundle.putInt("configuration", castRemoteDisplayOptions.zzanx);
            return new zzzg(context, looper, zzg2, castRemoteDisplayOptions.zzanf, bundle, castRemoteDisplayOptions.zzanw, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastRemoteDisplayOptions> API = new Api("CastRemoteDisplay.API", zzaie, zzyy.zzawz);
    public static final CastRemoteDisplayApi CastRemoteDisplayApi = new zzzf(API);

    public static final boolean isRemoteDisplaySdkSupported(Context context) {
        zzyu.initialize(context);
        return (Boolean)zzyu.zzawx.get();
    }

    private CastRemoteDisplay() {
    }

    public static final class CastRemoteDisplayOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzanf;
        final CastRemoteDisplaySessionCallbacks zzanw;
        final int zzanx;

        private CastRemoteDisplayOptions(Builder builder) {
            this.zzanf = builder.zzani;
            this.zzanw = builder.zzany;
            this.zzanx = builder.zzanz;
        }

        public static final class Builder {
            CastDevice zzani;
            CastRemoteDisplaySessionCallbacks zzany;
            int zzanz;

            public Builder(CastDevice castDevice, CastRemoteDisplaySessionCallbacks castRemoteDisplaySessionCallbacks) {
                zzac.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                this.zzani = castDevice;
                this.zzany = castRemoteDisplaySessionCallbacks;
                this.zzanz = 2;
            }

            public Builder setConfigPreset(@Configuration int n) {
                this.zzanz = n;
                return this;
            }

            public CastRemoteDisplayOptions build() {
                return new CastRemoteDisplayOptions(this);
            }
        }
    }

    public static interface CastRemoteDisplaySessionResult
    extends Result {
        public Display getPresentationDisplay();
    }

    public static interface CastRemoteDisplaySessionCallbacks {
        public void onRemoteDisplayEnded(Status var1);
    }

    public static @interface Configuration {
    }
}

