/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzyr;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakStatus
extends zza {
    public static final Parcelable.Creator<AdBreakStatus> CREATOR = new zzc();
    public static final int AD_BREAK_CLIP_NOT_SKIPPABLE = -1;
    private final long zzamS;
    private final long zzamT;
    private final String zzamU;
    private final String zzamV;
    private final long zzamW;

    AdBreakStatus(long l, long l2, String string, String string2, long l3) {
        this.zzamS = l;
        this.zzamT = l2;
        this.zzamU = string;
        this.zzamV = string2;
        this.zzamW = l3;
    }

    public String getBreakId() {
        return this.zzamU;
    }

    public String getBreakClipId() {
        return this.zzamV;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zzamS;
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzamT;
    }

    public long getWhenSkippableInMs() {
        return this.zzamW;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzamS, this.zzamT, this.zzamU, this.zzamV, this.zzamW});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakStatus)) {
            return false;
        }
        AdBreakStatus adBreakStatus = (AdBreakStatus)((Object)object);
        return this.zzamS == adBreakStatus.zzamS && this.zzamT == adBreakStatus.zzamT && zzyr.zza(this.zzamU, adBreakStatus.zzamU) && zzyr.zza(this.zzamV, adBreakStatus.zzamV) && this.zzamW == adBreakStatus.zzamW;
    }

    static AdBreakStatus zzl(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("currentBreakTime") || !jSONObject.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l = zzyr.zzf(jSONObject.getLong("currentBreakTime"));
            long l2 = zzyr.zzf(jSONObject.getLong("currentBreakClipTime"));
            String string = jSONObject.optString("breakId", null);
            String string2 = jSONObject.optString("breakClipId", null);
            long l3 = jSONObject.optLong("whenSkippable", -1L);
            if (l3 != -1L) {
                l3 = zzyr.zzf(l3);
            }
            return new AdBreakStatus(l, l2, string, string2, l3);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

