/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzi;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzyr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo
extends zza
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzi();
    private final String zzaoh;
    private int zzaoi;
    private String zzaoj;
    private MediaMetadata zzaok;
    private long zzaol;
    private List<MediaTrack> zzaom;
    private TextTrackStyle zzaon;
    String zzamN;
    private List<AdBreakInfo> zzaoo;
    private List<AdBreakClipInfo> zzaop;
    private JSONObject zzamO;

    MediaInfo(String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.zzaoh = string2;
        this.zzaoi = n;
        this.zzaoj = string3;
        this.zzaok = mediaMetadata;
        this.zzaol = l;
        this.zzaom = list;
        this.zzaon = textTrackStyle;
        this.zzamN = string4;
        if (this.zzamN != null) {
            try {
                this.zzamO = new JSONObject(this.zzamN);
            }
            catch (JSONException jSONException) {
                this.zzamO = null;
                this.zzamN = null;
            }
        } else {
            this.zzamO = null;
        }
        this.zzaoo = list2;
        this.zzaop = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzaoi = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzaoj = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzaok = new MediaMetadata(n);
            this.zzaok.zzn(jSONObject2);
        }
        this.zzaol = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzaol = zzyr.zzf(d);
        }
        if (jSONObject.has("tracks")) {
            this.zzaom = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzaom.add(mediaTrack);
            }
        } else {
            this.zzaom = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzn(jSONObject2);
            this.zzaon = textTrackStyle;
        } else {
            this.zzaon = null;
        }
        this.zzm(jSONObject);
        this.zzamO = jSONObject.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzaoh;
    }

    void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzaoi = n;
    }

    public int getStreamType() {
        return this.zzaoi;
    }

    void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzaoj = string2;
    }

    public String getContentType() {
        return this.zzaoj;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzaok = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzaok;
    }

    void zzC(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzaol = l;
    }

    public long getStreamDuration() {
        return this.zzaol;
    }

    void zzz(List<MediaTrack> list) {
        this.zzaom = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzaom;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzaon = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzaon;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzamO = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzamO;
    }

    public List<AdBreakInfo> getAdBreaks() {
        return this.zzaoo == null ? null : Collections.unmodifiableList(this.zzaoo);
    }

    public List<AdBreakClipInfo> getAdBreakClips() {
        return this.zzaop == null ? null : Collections.unmodifiableList(this.zzaop);
    }

    public void zzA(List<AdBreakInfo> list) {
        this.zzaoo = list;
    }

    void zzm(JSONObject jSONObject) throws JSONException {
        zza zza2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzaoo = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakInfo.zzk(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaoo.clear();
                    break;
                }
                this.zzaoo.add((AdBreakInfo)zza2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzaop = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakClipInfo.zzj(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaop.clear();
                    break;
                }
                this.zzaop.add((AdBreakClipInfo)zza2);
            }
        }
    }

    private void zzsx() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzaoh)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzaoj)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzaoi == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzaoh);
            switch (this.zzaoi) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzaoj != null) {
                jSONObject.put("contentType", (Object)this.zzaoj);
            }
            if (this.zzaok != null) {
                jSONObject.put("metadata", (Object)this.zzaok.toJson());
            }
            if (this.zzaol <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzyr.zzG(this.zzaol));
            }
            if (this.zzaom != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzaom) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzaon != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzaon.toJson());
            }
            if (this.zzamO != null) {
                jSONObject.put("customData", (Object)this.zzamO);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzamO == null != (mediaInfo.zzamO == null)) {
            return false;
        }
        if (this.zzamO != null && mediaInfo.zzamO != null && !zzq.zze((Object)this.zzamO, (Object)mediaInfo.zzamO)) {
            return false;
        }
        return zzyr.zza(this.zzaoh, mediaInfo.zzaoh) && this.zzaoi == mediaInfo.zzaoi && zzyr.zza(this.zzaoj, mediaInfo.zzaoj) && zzyr.zza(this.zzaok, mediaInfo.zzaok) && this.zzaol == mediaInfo.zzaol && zzyr.zza(this.zzaom, mediaInfo.zzaom) && zzyr.zza(this.zzaon, mediaInfo.zzaon) && zzyr.zza(this.zzaoo, mediaInfo.zzaoo) && zzyr.zza(this.zzaop, mediaInfo.zzaop);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaoh, this.zzaoi, this.zzaoj, this.zzaok, this.zzaol, String.valueOf(this.zzamO), this.zzaom, this.zzaon, this.zzaoo, this.zzaop});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzamN = this.zzamO == null ? null : this.zzamO.toString();
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaInfo zzaoq;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzaoq = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzaoq.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzaoq.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzaoq.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzaoq.zzC(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaoq.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzaoq.zzz(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzaoq.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzaoq.zzsx();
            return this.zzaoq;
        }
    }
}

