/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzk;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzyr;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zza {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzk();
    private MediaInfo zzaoy;
    private int zzaoz;
    private boolean zzaoA;
    private double zzaoB;
    private double zzaoC;
    private double zzaoD;
    private long[] zzaoE;
    String zzamN;
    private JSONObject zzamO;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzaoy = mediaInfo;
        this.zzaoz = n;
        this.zzaoA = bl;
        this.zzaoB = d;
        this.zzaoC = d2;
        this.zzaoD = d3;
        this.zzaoE = lArray;
        this.zzamN = string2;
        if (this.zzamN != null) {
            try {
                this.zzamO = new JSONObject(this.zzamN);
            }
            catch (JSONException jSONException) {
                this.zzamO = null;
                this.zzamN = null;
            }
        } else {
            this.zzamO = null;
        }
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzo(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzaoy == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzamO = mediaQueueItem.getCustomData();
    }

    public boolean zzo(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzaoy = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzaoz != (n = jSONObject.getInt("itemId"))) {
            this.zzaoz = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzaoA != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzaoA = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzaoB) > 1.0E-7) {
            this.zzaoB = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzaoC) > 1.0E-7) {
            this.zzaoC = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzaoD) > 1.0E-7) {
            this.zzaoD = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzaoE == null) {
                bl2 = true;
            } else if (this.zzaoE.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzaoE[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzaoE = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzamO = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzaoy;
    }

    public int getItemId() {
        return this.zzaoz;
    }

    void zzbP(int n) {
        this.zzaoz = n;
    }

    public boolean getAutoplay() {
        return this.zzaoA;
    }

    void zzak(boolean bl) {
        this.zzaoA = bl;
    }

    public double getStartTime() {
        return this.zzaoB;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzaoB = d;
    }

    public double getPlaybackDuration() {
        return this.zzaoC;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzaoC = d;
    }

    public double getPreloadTime() {
        return this.zzaoD;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzaoD = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzaoE;
    }

    void zza(long[] lArray) {
        this.zzaoE = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzamO;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzamO = jSONObject;
    }

    void zzsx() throws IllegalArgumentException {
        if (this.zzaoy == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzaoB) || this.zzaoB < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzaoC)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzaoD) || this.zzaoD < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzaoy.toJson());
            if (this.zzaoz != 0) {
                jSONObject.put("itemId", this.zzaoz);
            }
            jSONObject.put("autoplay", this.zzaoA);
            jSONObject.put("startTime", this.zzaoB);
            if (this.zzaoC != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzaoC);
            }
            jSONObject.put("preloadTime", this.zzaoD);
            if (this.zzaoE != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzaoE) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzamO != null) {
                jSONObject.put("customData", (Object)this.zzamO);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzamO == null != (mediaQueueItem.zzamO == null)) {
            return false;
        }
        if (this.zzamO != null && mediaQueueItem.zzamO != null && !zzq.zze((Object)this.zzamO, (Object)mediaQueueItem.zzamO)) {
            return false;
        }
        return zzyr.zza(this.zzaoy, mediaQueueItem.zzaoy) && this.zzaoz == mediaQueueItem.zzaoz && this.zzaoA == mediaQueueItem.zzaoA && this.zzaoB == mediaQueueItem.zzaoB && this.zzaoC == mediaQueueItem.zzaoC && this.zzaoD == mediaQueueItem.zzaoD && Arrays.equals(this.zzaoE, mediaQueueItem.zzaoE);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaoy, this.zzaoz, this.zzaoA, this.zzaoB, this.zzaoC, this.zzaoD, Arrays.hashCode(this.zzaoE), String.valueOf(this.zzamO)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzamN = this.zzamO == null ? null : this.zzamO.toString();
        zzk.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaQueueItem zzaoF;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzaoF = new MediaQueueItem(mediaInfo);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzaoF = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzaoF = new MediaQueueItem(mediaQueueItem);
        }

        public Builder clearItemId() {
            this.zzaoF.zzbP(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzaoF.zzak(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzaoF.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzaoF.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzaoF.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzaoF.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaoF.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzaoF.zzsx();
            return this.zzaoF;
        }
    }
}

