/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzl;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzyr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zza {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzl();
    private MediaInfo zzaoq;
    private long zzaoG;
    private int zzaoH;
    private double zzaoI;
    private int zzaoJ;
    private int zzaoK;
    private long zzaoL;
    long zzaoM;
    private double zzaoN;
    private boolean zzaoO;
    private long[] zzaoE;
    private int zzaoP;
    private int zzaoQ;
    String zzamN;
    private JSONObject zzamO;
    int zzaoR;
    final ArrayList<MediaQueueItem> zzaoS = new ArrayList();
    private boolean zzaoT;
    private AdBreakStatus zzaoU;
    private VideoInfo zzaoV;
    private final SparseArray<Integer> zzaoW = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzaoq = mediaInfo;
        this.zzaoG = l;
        this.zzaoH = n;
        this.zzaoI = d;
        this.zzaoJ = n2;
        this.zzaoK = n3;
        this.zzaoL = l2;
        this.zzaoM = l3;
        this.zzaoN = d2;
        this.zzaoO = bl;
        this.zzaoE = lArray;
        this.zzaoP = n4;
        this.zzaoQ = n5;
        this.zzamN = string2;
        if (this.zzamN != null) {
            try {
                this.zzamO = new JSONObject(this.zzamN);
            }
            catch (JSONException jSONException) {
                this.zzamO = null;
                this.zzamN = null;
            }
        } else {
            this.zzamO = null;
        }
        this.zzaoR = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzaoT = bl2;
        this.zzaoU = adBreakStatus;
        this.zzaoV = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    public long zzsy() {
        return this.zzaoG;
    }

    public int getPlayerState() {
        return this.zzaoJ;
    }

    public int getIdleReason() {
        return this.zzaoK;
    }

    public double getPlaybackRate() {
        return this.zzaoI;
    }

    public MediaInfo getMediaInfo() {
        return this.zzaoq;
    }

    public long getStreamPosition() {
        return this.zzaoL;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzaoM & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzaoN;
    }

    public boolean isMute() {
        return this.zzaoO;
    }

    public long[] getActiveTrackIds() {
        return this.zzaoE;
    }

    public JSONObject getCustomData() {
        return this.zzamO;
    }

    public int getCurrentItemId() {
        return this.zzaoH;
    }

    public int getLoadingItemId() {
        return this.zzaoP;
    }

    public int getPreloadedItemId() {
        return this.zzaoQ;
    }

    public int getQueueRepeatMode() {
        return this.zzaoR;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzaoS;
    }

    public int getQueueItemCount() {
        return this.zzaoS.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzaoT;
    }

    public void zzal(boolean bl) {
        this.zzaoT = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzaoU;
    }

    public VideoInfo getVideoInfo() {
        return this.zzaoV;
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l;
        long l2;
        double d;
        int n7 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzaoG) {
            this.zzaoG = l3;
            n7 = 1;
        }
        if (jSONObject.has("playerState")) {
            int n8 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n8 = 1;
            } else if (string2.equals("PLAYING")) {
                n8 = 2;
            } else if (string2.equals("PAUSED")) {
                n8 = 3;
            } else if (string2.equals("BUFFERING")) {
                n8 = 4;
            }
            if (n8 != this.zzaoJ) {
                this.zzaoJ = n8;
                n7 |= 2;
            }
            if (n8 == 1 && jSONObject.has("idleReason")) {
                int n9 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n9 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n9 = 3;
                } else if (string2.equals("FINISHED")) {
                    n9 = 1;
                } else if (string2.equals("ERROR")) {
                    n9 = 4;
                }
                if (n9 != this.zzaoK) {
                    this.zzaoK = n9;
                    n7 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzaoI != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzaoI = d;
            n7 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzyr.zzf(jSONObject.getDouble("currentTime"))) != this.zzaoL) {
            this.zzaoL = l2;
            n7 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzaoM) {
            this.zzaoM = l;
            n7 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzaoN) {
                this.zzaoN = d2;
                n7 |= 2;
            }
            if ((n6 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzaoO) {
                this.zzaoO = n6;
                n7 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n6 = jSONArray.length();
            lArray = new long[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                lArray[n5] = jSONArray.getLong(n5);
            }
            if (this.zzaoE == null) {
                bl = true;
            } else if (this.zzaoE.length != n6) {
                bl = true;
            } else {
                for (n5 = 0; n5 < n6; ++n5) {
                    if (this.zzaoE[n5] == lArray[n5]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzaoE = lArray;
            }
        } else if (this.zzaoE != null) {
            bl = true;
        }
        if (bl) {
            this.zzaoE = lArray;
            n7 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzamO = jSONObject.getJSONObject("customData");
            this.zzamN = null;
            n7 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            MediaInfo mediaInfo = new MediaInfo(jSONObject3);
            if (this.zzaoq == null || this.zzaoq != null && !this.zzaoq.equals((Object)mediaInfo)) {
                this.zzaoq = mediaInfo;
                n7 |= 2;
            }
            if (jSONObject3.has("metadata")) {
                n7 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzaoH != (n4 = jSONObject.getInt("currentItemId"))) {
            this.zzaoH = n4;
            n7 |= 2;
        }
        if (this.zzaoQ != (n3 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzaoQ = n3;
            n7 |= 0x10;
        }
        if (this.zzaoP != (n2 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzaoP = n2;
            n7 |= 2;
        }
        int n10 = n5 = this.zzaoq == null ? -1 : this.zzaoq.getStreamType();
        if (!this.zzf(this.zzaoJ, this.zzaoK, this.zzaoP, n5)) {
            if (this.zzp(jSONObject)) {
                n7 |= 8;
            }
        } else {
            this.zzaoH = 0;
            this.zzaoP = 0;
            this.zzaoQ = 0;
            if (!this.zzaoS.isEmpty()) {
                this.zzsz();
                n7 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzl(jSONObject.optJSONObject("breakStatus"));
        if (this.zzaoU == null && adBreakStatus != null || this.zzaoU != null && !this.zzaoU.equals((Object)adBreakStatus)) {
            this.zzal(adBreakStatus != null);
            this.zzaoU = adBreakStatus;
            n7 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzq(jSONObject.optJSONObject("videoInfo"));
        if (this.zzaoV == null && videoInfo != null || this.zzaoV != null && !this.zzaoV.equals((Object)videoInfo)) {
            this.zzaoV = videoInfo;
            n7 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzaoq != null) {
            this.zzaoq.zzm(jSONObject.getJSONObject("breakInfo"));
            n7 |= 2;
        }
        return n7;
    }

    private boolean zzf(int n, int n2, int n3, int n4) {
        if (n != 1) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: {
                return n3 == 0;
            }
            case 2: {
                return n4 != 2;
            }
        }
        return true;
    }

    private void zzsz() {
        this.zzaoR = 0;
        this.zzaoS.clear();
        this.zzaoW.clear();
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzaoW.get(n);
        return n2 == null ? null : this.zzaoS.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzaoS.size()) {
            return null;
        }
        return this.zzaoS.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzaoW.get(n);
    }

    boolean zzp(JSONObject jSONObject) throws JSONException {
        int n;
        String string2;
        boolean bl = false;
        if (jSONObject.has("repeatMode")) {
            String string3;
            int n2 = this.zzaoR;
            string2 = string3 = jSONObject.getString("repeatMode");
            n = -1;
            switch (string2.hashCode()) {
                case 1645952171: {
                    if (!string2.equals("REPEAT_OFF")) break;
                    n = 0;
                    break;
                }
                case 1645938909: {
                    if (!string2.equals("REPEAT_ALL")) break;
                    n = 1;
                    break;
                }
                case -962896020: {
                    if (!string2.equals("REPEAT_SINGLE")) break;
                    n = 2;
                    break;
                }
                case -1118317585: {
                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                }
            }
            if (this.zzaoR != n2) {
                this.zzaoR = n2;
                bl = true;
            }
        }
        if (jSONObject.has("items")) {
            JSONArray jSONArray = jSONObject.getJSONArray("items");
            int n3 = jSONArray.length();
            string2 = new SparseArray();
            for (n = 0; n < n3; ++n) {
                string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
            }
            MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
            for (int i = 0; i < n3; ++i) {
                Integer n4 = (Integer)string2.get(i);
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                MediaQueueItem mediaQueueItem = this.getItemById(n4);
                if (mediaQueueItem != null) {
                    bl |= mediaQueueItem.zzo(jSONObject2);
                    mediaQueueItemArray[i] = mediaQueueItem;
                    if (i == this.getIndexById(n4)) continue;
                    bl = true;
                    continue;
                }
                bl = true;
                if (n4 == this.zzaoH) {
                    mediaQueueItemArray[i] = new MediaQueueItem.Builder(this.zzaoq).build();
                    mediaQueueItemArray[i].zzo(jSONObject2);
                    continue;
                }
                mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
            }
            if (this.zzaoS.size() != n3) {
                bl = true;
            }
            this.zza(mediaQueueItemArray);
        }
        return bl;
    }

    private void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzaoS.clear();
        this.zzaoW.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzaoS.add(mediaQueueItem);
            this.zzaoW.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzamO == null != (mediaStatus.zzamO == null)) {
            return false;
        }
        return this.zzaoG == mediaStatus.zzaoG && this.zzaoH == mediaStatus.zzaoH && this.zzaoI == mediaStatus.zzaoI && this.zzaoJ == mediaStatus.zzaoJ && this.zzaoK == mediaStatus.zzaoK && this.zzaoL == mediaStatus.zzaoL && this.zzaoN == mediaStatus.zzaoN && this.zzaoO == mediaStatus.zzaoO && this.zzaoP == mediaStatus.zzaoP && this.zzaoQ == mediaStatus.zzaoQ && this.zzaoR == mediaStatus.zzaoR && Arrays.equals(this.zzaoE, mediaStatus.zzaoE) && zzyr.zza(this.zzaoM, mediaStatus.zzaoM) && zzyr.zza(this.zzaoS, mediaStatus.zzaoS) && zzyr.zza(this.zzaoq, mediaStatus.zzaoq) && this.zza(mediaStatus) && this.zzaoT == mediaStatus.isPlayingAd();
    }

    private boolean zza(MediaStatus mediaStatus) {
        return this.zzamO == null || mediaStatus.zzamO == null || zzq.zze((Object)this.zzamO, (Object)mediaStatus.zzamO);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzaoq, this.zzaoG, this.zzaoH, this.zzaoI, this.zzaoJ, this.zzaoK, this.zzaoL, this.zzaoM, this.zzaoN, this.zzaoO, Arrays.hashCode(this.zzaoE), this.zzaoP, this.zzaoQ, String.valueOf(this.zzamO), this.zzaoR, this.zzaoS, this.zzaoT});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzamN = this.zzamO == null ? null : this.zzamO.toString();
        zzl.zza(this, parcel, n);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzaoU == null || this.zzaoq == null) {
            return null;
        }
        String string2 = this.zzaoU.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzaoq.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzaoU == null || this.zzaoq == null) {
            return null;
        }
        String string2 = this.zzaoU.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzaoq.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

