/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyf;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzyh;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyj;
import com.google.android.gms.internal.zzyk;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyo;
import com.google.android.gms.internal.zzyq;
import com.google.android.gms.internal.zzyr;
import com.google.android.gms.internal.zzyz;
import com.google.android.gms.internal.zzzc;
import com.google.android.gms.internal.zzzd;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzye
extends zzyo {
    static final String NAMESPACE = zzyr.zzcR("com.google.cast.games");
    private static final zzyz zzanA = new zzyz("GameManagerChannel");
    private final Map<String, String> zzava = new ConcurrentHashMap<String, String>();
    private final List<zzzd> zzavb;
    private final SharedPreferences zzBd;
    private final String zzavc;
    private final Cast.CastApi zzaql;
    private final GoogleApiClient zzasD;
    private zzyf zzavd;
    private boolean zzave = false;
    private GameManagerState zzavf;
    private GameManagerState zzavg;
    private String zzavh;
    private JSONObject zzavi;
    private long zzavj = 0L;
    private GameManagerClient.Listener zzavk;
    private final com.google.android.gms.common.util.zze zzuP;
    private String zzavl;

    public zzye(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzuP = zzi.zzzc();
        this.zzavb = new ArrayList<zzzd>();
        this.zzavc = string2;
        this.zzaql = castApi;
        this.zzasD = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzBd = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzavg = null;
        this.zzavf = new zzyi(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzasD.zzb((zzaad.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzye.this.zzaql.setMessageReceivedCallbacks(zzye.this.zzasD, zzye.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
                            zzye.this.zzcP(string3);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzup().zza(-1L, 8, null);
                    return;
                }
                zzye.this.zzun();
                zzye.this.zzum();
                zzye.this.zza(null, 1100, null, this.zzup());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzave) {
            return;
        }
        this.zzavf = null;
        this.zzavg = null;
        this.zzavh = null;
        this.zzavi = null;
        this.zzave = true;
        try {
            this.zzaql.removeMessageReceivedCallbacks(this.zzasD, this.getNamespace());
        }
        catch (IOException iOException) {
            zzanA.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzuk();
        return this.zzasD.zzb((zzaad.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzyh.zzci(n);
                if (n2 == 0) {
                    this.zzup().zza(-1L, 2001, null);
                    zzanA.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzye.this.zza(string2, n2, jSONObject, this.zzup());
            }
        });
    }

    public synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzuk();
        long l = ++this.zzavj;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzaql.sendMessage(this.zzasD, this.getNamespace(), jSONObject2.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String string2, final JSONObject jSONObject) throws IllegalStateException {
        this.zzuk();
        return this.zzasD.zzb((zzaad.zza)new zza(){

            @Override
            public void execute() {
                zzye.this.zza(string2, 6, jSONObject, this.zzup());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzuk();
        return this.zzavf;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzuk();
        return this.zzavl;
    }

    public synchronized String zzcO(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzava.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzavk = listener;
    }

    @Override
    public final void zzcP(String string2) {
        boolean bl;
        zzyg zzyg2;
        zzanA.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzyg2 = zzyg.zzr(jSONObject);
        }
        catch (JSONException jSONException) {
            zzanA.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzyg2 == null) {
            zzanA.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzyg2.zzuw() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzyg2.zzur() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzyg2.zzuv())) {
            this.zzava.put(zzyg2.getPlayerId(), zzyg2.zzuv());
            this.zzum();
        }
        if (zzyg2.getStatusCode() == 0) {
            this.zza(zzyg2);
        } else {
            zzanA.zzf("Not updating from game message because the message contains error code: %d", zzyg2.getStatusCode());
        }
        int n = this.zzch(zzyg2.getStatusCode());
        if (bl) {
            this.zzb(zzyg2.getRequestId(), n, zzyg2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzul();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzave;
    }

    public synchronized boolean isInitialized() {
        return this.zzavd != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzF(long l) {
        Iterator<zzzd> iterator = this.zzavb.iterator();
        while (iterator.hasNext()) {
            zzzd zzzd2 = iterator.next();
            if (!zzzd2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzzd.zzqS;
        synchronized (object) {
            for (zzzd zzzd3 : this.zzavb) {
                if (!zzzd3.zzuO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzch(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzanA.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n).toString(), new Object[0]);
        return 13;
    }

    private synchronized void zzuk() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzzc zzzc2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzavj, string2, n, jSONObject)) == null) {
            zzzc2.zza(-1L, 2001, null);
            zzanA.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzzd zzzd2 = new zzzd(this.zzuP, 30000L);
        zzzd2.zza(l, zzzc2);
        this.zzavb.add(zzzd2);
        this.zzap(true);
        this.zzaql.sendMessage(this.zzasD, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzye.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzcO(string2));
        }
        catch (JSONException jSONException) {
            zzanA.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzyg zzyg2) {
        boolean bl = zzyg2.zzur() == 1;
        this.zzavg = this.zzavf;
        if (bl && zzyg2.zzuw() != null) {
            this.zzavd = zzyg2.zzuw();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzyk zzyk2 : zzyg2.zzut()) {
            String string2 = zzyk2.getPlayerId();
            zzyj zzyj2 = new zzyj(string2, zzyk2.getPlayerState(), zzyk2.getPlayerData(), this.zzava.containsKey(string2));
            arrayList.add(zzyj2);
        }
        this.zzavf = new zzyi(zzyg2.getLobbyState(), zzyg2.getGameplayState(), zzyg2.zzuu(), zzyg2.getGameData(), arrayList, this.zzavd.zzuq(), this.zzavd.getMaxPlayers());
        PlayerInfo playerInfo = this.zzavf.getPlayer(zzyg2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzyg2.zzur() == 2) {
            this.zzavh = zzyg2.getPlayerId();
            this.zzavi = zzyg2.getExtraMessageData();
        }
    }

    private void zzul() {
        if (this.zzavk != null) {
            if (this.zzavg != null && !this.zzavf.equals(this.zzavg)) {
                this.zzavk.onStateChanged(this.zzavf, this.zzavg);
            }
            if (this.zzavi != null && this.zzavh != null) {
                this.zzavk.onGameMessageReceived(this.zzavh, this.zzavi);
            }
        }
        this.zzavg = null;
        this.zzavh = null;
        this.zzavi = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzzd> iterator = this.zzavb.iterator();
        while (iterator.hasNext()) {
            zzzd zzzd2 = iterator.next();
            if (!zzzd2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzum() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzavc);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzava));
            this.zzBd.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzanA.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzun() {
        String string2 = this.zzBd.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzavc.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzava.put(string4, jSONObject2.getString(string4));
                }
                this.zzavj = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzanA.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            super(zzye.this);
            this.zzapH = new zzzc(){

                @Override
                public void zzD(long l) {
                    zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzb(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzyg zzyg2 = (zzyg)object;
                        String string2 = zzyg2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzye.this.zzavl = string2;
                        }
                        zza.this.zzb(new zze(new Status(n, zzyg2.zzus(), null), string2, zzyg2.getRequestId(), zzyg2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzs(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzavu;

        public zzc(GameManagerClient gameManagerClient) {
            super(zzye.this);
            this.zzavu = gameManagerClient;
            this.zzapH = new zzzc(){

                @Override
                public void zzD(long l) {
                    zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzb(new zzd(new Status(n, null, null), zzc.this.zzavu));
                            return;
                        }
                        zzyg zzyg2 = (zzyg)object;
                        zzyf zzyf2 = zzyg2.zzuw();
                        if (zzyf2 != null && !zzyr.zza("1.0.0", zzyf2.getVersion())) {
                            zzye.this.zzavd = null;
                            zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzyf2.getVersion(), "1.0.0"))));
                            return;
                        }
                        zzc.this.zzb(new zzd(new Status(n, zzyg2.zzus(), null), zzc.this.zzavu));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzt(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzt(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends zzyn<R> {
        protected zzzc zzapH;

        public zzb(zzye zzye2) {
            super(zzye2.zzasD);
        }

        protected void zza(zzyq zzyq2) {
            this.execute();
        }

        public zzzc zzup() {
            return this.zzapH;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzair;
        private final String zzavw;
        private final long zzavx;
        private final JSONObject zzavy;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.zzair = status;
            this.zzavw = string2;
            this.zzavx = l;
            this.zzavy = jSONObject;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getPlayerId() {
            return this.zzavw;
        }

        @Override
        public long getRequestId() {
            return this.zzavx;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzavy;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzair;
        private final GameManagerClient zzavu;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzair = status;
            this.zzavu = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzavu;
        }
    }
}

