/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyl;
import com.google.android.gms.internal.zzyr;
import com.google.android.gms.internal.zzys;
import com.google.android.gms.internal.zzyw;
import com.google.android.gms.internal.zzyx;
import com.google.android.gms.internal.zzyz;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class zzyq
extends zzl<zzyw> {
    private static final zzyz zzanA = new zzyz("CastClientImpl");
    private ApplicationMetadata zzavU;
    private final CastDevice zzaqp;
    private final Cast.Listener zzanj;
    private final Map<String, Cast.MessageReceivedCallback> zzavV;
    private final long zzavW;
    private final Bundle mExtras;
    private zzb zzavX;
    private String zzavY;
    private boolean zzaoO;
    private boolean zzavZ;
    private boolean zzawa;
    private boolean zzawb;
    private double zzaoN;
    private int zzawc;
    private int zzawd;
    private final AtomicLong zzawe;
    private String zzawf;
    private String zzawg;
    private Bundle zzawh;
    private final Map<Long, zzaad.zzb<Status>> zzawi;
    private zzaad.zzb<Cast.ApplicationConnectionResult> zzawj;
    private zzaad.zzb<Status> zzawk;
    private static final Object zzawl = new Object();
    private static final Object zzawm = new Object();

    public zzyq(Context context, Looper looper, zzg zzg2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaqp = castDevice;
        this.zzanj = listener;
        this.zzavW = l;
        this.mExtras = bundle;
        this.zzavV = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzawe = new AtomicLong(0L);
        this.zzawi = new HashMap<Long, zzaad.zzb<Status>>();
        this.zzuA();
    }

    private void zzuA() {
        this.zzawb = false;
        this.zzawc = -1;
        this.zzawd = -1;
        this.zzavU = null;
        this.zzavY = null;
        this.zzaoN = 0.0;
        this.zzaoO = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzanA.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzawb = true;
            this.zzavZ = true;
            this.zzawa = true;
        } else {
            this.zzawb = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzawh = new Bundle();
            this.zzawh.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public void disconnect() {
        zzanA.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzavX, this.isConnected());
        zzb zzb2 = this.zzavX;
        this.zzavX = null;
        if (zzb2 == null || zzb2.zzuI() == null) {
            zzanA.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzuD();
        try {
            this.zzuC().disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzanA.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzuB() {
        if (this.zzawh != null) {
            Bundle bundle = this.zzawh;
            this.zzawh = null;
            return bundle;
        }
        return super.zzuB();
    }

    @NonNull
    protected String zzez() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected String zzeA() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzyw zzbg(IBinder iBinder) {
        return zzyw.zza.zzbh(iBinder);
    }

    protected Bundle zzqL() {
        Bundle bundle = new Bundle();
        zzanA.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzawf, this.zzawg);
        this.zzaqp.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzavW);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzavX = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzavX.asBinder()));
        if (this.zzawf != null) {
            bundle.putString("last_application_id", this.zzawf);
            if (this.zzawg != null) {
                bundle.putString("last_session_id", this.zzawg);
            }
        }
        return bundle;
    }

    zzyw zzuC() throws DeadObjectException {
        return (zzyw)super.zzxD();
    }

    public void zza(String string2, String string3, zzaad.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzyr.zzcQ(string2);
        this.zzuE();
        long l = this.zzawe.incrementAndGet();
        try {
            this.zzawi.put(l, zzb2);
            this.zzuC().zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzawi.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzaad.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.setRelaunchIfRunning(bl);
        this.zza(string2, launchOptions, zzb2);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzaad.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        this.zzuC().zzb(string2, launchOptions);
    }

    public void zza(String string2, String string3, zzf zzf2, zzaad.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (zzf2 == null) {
            zzf2 = new zzf();
        }
        this.zzuC().zza(string2, string3, zzf2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzaad.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzawl;
        synchronized (object) {
            if (this.zzawj != null) {
                this.zzawj.setResult((Object)new zza(new Status(2002)));
            }
            this.zzawj = zzb2;
        }
    }

    public void zzb(zzaad.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzuC().zzuK();
    }

    public void zza(String string2, zzaad.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzuC().zzcK(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzaad.zzb<Status> zzb2) {
        Object object = zzawm;
        synchronized (object) {
            if (this.zzawk != null) {
                zzb2.setResult((Object)new Status(2001));
                return;
            }
            this.zzawk = zzb2;
        }
    }

    public void requestStatus() throws IllegalStateException, RemoteException {
        this.zzuC().requestStatus();
    }

    public void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        this.zzuC().zza(d, this.zzaoN, this.zzaoO);
    }

    public void setMute(boolean bl) throws IllegalStateException, RemoteException {
        this.zzuC().zza(bl, this.zzaoN, this.zzaoO);
    }

    public double getVolume() throws IllegalStateException {
        this.zzuE();
        return this.zzaoN;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzuE();
        return this.zzaoO;
    }

    public int getActiveInputState() throws IllegalStateException {
        this.zzuE();
        return this.zzawc;
    }

    public int getStandbyState() throws IllegalStateException {
        this.zzuE();
        return this.zzawd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzyr.zzcQ(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzavV;
            synchronized (map) {
                this.zzavV.put(string2, messageReceivedCallback);
            }
            this.zzuC().zzcT(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzavV;
        synchronized (map) {
            messageReceivedCallback = this.zzavV.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                this.zzuC().zzcU(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzanA.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzuE();
        return this.zzavU;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzuE();
        return this.zzavY;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzuD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzuD() {
        zzanA.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzavV;
        synchronized (map) {
            this.zzavV.clear();
        }
    }

    private void zza(zzys zzys2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzys2.getApplicationMetadata();
        if (!zzyr.zza(applicationMetadata, this.zzavU)) {
            this.zzavU = applicationMetadata;
            this.zzanj.onApplicationMetadataChanged(this.zzavU);
        }
        boolean bl2 = false;
        double d = zzys2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzaoN) > 1.0E-7) {
            this.zzaoN = d;
            bl2 = true;
        }
        if ((bl = zzys2.zzuJ()) != this.zzaoO) {
            this.zzaoO = bl;
            bl2 = true;
        }
        zzanA.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzawa);
        if (this.zzanj != null && (bl2 || this.zzawa)) {
            this.zzanj.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzys2.getActiveInputState();
        if (n != this.zzawc) {
            this.zzawc = n;
            bl3 = true;
        }
        zzanA.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzawa);
        if (this.zzanj != null && (bl3 || this.zzawa)) {
            this.zzanj.onActiveInputStateChanged(this.zzawc);
        }
        boolean bl4 = false;
        int n2 = zzys2.getStandbyState();
        if (n2 != this.zzawd) {
            this.zzawd = n2;
            bl4 = true;
        }
        zzanA.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzawa);
        if (this.zzanj != null && (bl4 || this.zzawa)) {
            this.zzanj.onStandbyStateChanged(this.zzawd);
        }
        this.zzawa = false;
    }

    private void zza(zzyl zzyl2) {
        boolean bl = false;
        String string2 = zzyl2.zzux();
        if (!zzyr.zza(string2, this.zzavY)) {
            this.zzavY = string2;
            bl = true;
        }
        zzanA.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzavZ);
        if (this.zzanj != null && (bl || this.zzavZ)) {
            this.zzanj.onApplicationStatusChanged();
        }
        this.zzavZ = false;
    }

    void zzuE() throws IllegalStateException {
        if (!this.zzawb || this.zzavX == null || this.zzavX.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzbg(iBinder);
    }

    static class zzb
    extends zzyx.zza {
        private final AtomicReference<zzyq> zzawq;
        private final Handler mHandler;

        public zzb(zzyq zzyq2) {
            this.zzawq = new AtomicReference<zzyq>(zzyq2);
            this.mHandler = new Handler(zzyq2.getLooper());
        }

        public zzyq zzuI() {
            zzyq zzyq2 = this.zzawq.getAndSet(null);
            if (zzyq2 == null) {
                return null;
            }
            zzyq2.zzuA();
            return zzyq2;
        }

        public boolean isDisposed() {
            return this.zzawq.get() == null;
        }

        @Override
        public void zzcl(int n) {
            zzyq zzyq2 = this.zzuI();
            if (zzyq2 == null) {
                return;
            }
            zzanA.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zzyq2.zzcS(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzyq2.zzavU = applicationMetadata;
            zzyq2.zzawf = applicationMetadata.getApplicationId();
            zzyq2.zzawg = string3;
            zzyq2.zzavY = string2;
            Object object = zzawl;
            synchronized (object) {
                if (zzyq2.zzawj != null) {
                    zzyq2.zzawj.setResult((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zzyq2.zzawj = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbZ(int n) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            Object object = zzawl;
            synchronized (object) {
                if (zzyq2.zzawj != null) {
                    zzyq2.zzawj.setResult((Object)new zza(new Status(n)));
                    zzyq2.zzawj = null;
                }
            }
        }

        @Override
        public void zzcm(int n) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            this.zza(zzyq2, n);
        }

        @Override
        public void zzcn(int n) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            this.zza(zzyq2, n);
        }

        @Override
        public void onApplicationDisconnected(final int n) {
            final zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzyq2.zzawf = null;
            zzyq2.zzawg = null;
            this.zza(zzyq2, n);
            if (zzyq2.zzanj != null) {
                this.mHandler.post(new Runnable(this){

                    @Override
                    public void run() {
                        zzyq2.zzanj.onApplicationDisconnected(n);
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzanA.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final zzys zzys2) {
            final zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzanA.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(this){

                @Override
                public void run() {
                    zzyq2.zza(zzys2);
                }
            });
        }

        @Override
        public void zzb(final zzyl zzyl2) {
            final zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzanA.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(this){

                @Override
                public void run() {
                    zzyq2.zza(zzyl2);
                }
            });
        }

        @Override
        public void zzA(final String string2, final String string3) {
            final zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzanA.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zzyq2.zzavV;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zzyq2.zzavV.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zzyq2.zzaqp, string2, string3);
                    } else {
                        zzanA.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            zzanA.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            this.zza(zzyq2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zzyq zzyq2 = this.zzawq.get();
            if (zzyq2 == null) {
                return;
            }
            this.zza(zzyq2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zzyq zzyq2, long l, int n) {
            zzaad.zzb zzb2;
            Map map = zzyq2.zzawi;
            synchronized (map) {
                zzb2 = (zzaad.zzb)zzyq2.zzawi.remove(l);
            }
            if (zzb2 != null) {
                zzb2.setResult((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zzyq zzyq2, int n) {
            Object object = zzawm;
            synchronized (object) {
                if (zzyq2.zzawk != null) {
                    zzyq2.zzawk.setResult((Object)new Status(n));
                    zzyq2.zzawk = null;
                    return true;
                }
            }
            return false;
        }
    }

    static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzair;
        private final ApplicationMetadata zzawn;
        private final String zzawo;
        private final String zzWD;
        private final boolean zzawp;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzair = status;
            this.zzawn = applicationMetadata;
            this.zzawo = string2;
            this.zzWD = string3;
            this.zzawp = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzawn;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzawo;
        }

        @Override
        public String getSessionId() {
            return this.zzWD;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzawp;
        }
    }
}

