/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzyo;
import com.google.android.gms.internal.zzyr;
import com.google.android.gms.internal.zzzc;
import com.google.android.gms.internal.zzzd;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzza
extends zzyo {
    public static final String NAMESPACE = zzyr.zzcR("com.google.cast.media");
    private long zzawJ;
    private MediaStatus zzawK;
    private final List<zzzd> zzavb;
    private zza zzawL;
    private final zzzd zzawM;
    private final zzzd zzawN;
    private final zzzd zzawO;
    private final zzzd zzawP;
    private final zzzd zzawQ;
    private final zzzd zzawR;
    private final zzzd zzawS;
    private final zzzd zzawT;
    private final zzzd zzawU;
    private final zzzd zzawV;
    private final zzzd zzawW;
    private final zzzd zzawX;
    private final zzzd zzawY;
    private final zzzd zzawZ;

    public zzza(String string2) {
        super(NAMESPACE, zzi.zzzc(), "MediaControlChannel", string2, 1000L);
        this.zzawM = new zzzd(this.zzuP, 86400000L);
        this.zzawN = new zzzd(this.zzuP, 86400000L);
        this.zzawO = new zzzd(this.zzuP, 86400000L);
        this.zzawP = new zzzd(this.zzuP, 86400000L);
        this.zzawQ = new zzzd(this.zzuP, 86400000L);
        this.zzawR = new zzzd(this.zzuP, 86400000L);
        this.zzawS = new zzzd(this.zzuP, 86400000L);
        this.zzawT = new zzzd(this.zzuP, 86400000L);
        this.zzawU = new zzzd(this.zzuP, 86400000L);
        this.zzawV = new zzzd(this.zzuP, 86400000L);
        this.zzawW = new zzzd(this.zzuP, 86400000L);
        this.zzawX = new zzzd(this.zzuP, 86400000L);
        this.zzawY = new zzzd(this.zzuP, 86400000L);
        this.zzawZ = new zzzd(this.zzuP, 86400000L);
        this.zzavb = new ArrayList<zzzd>();
        this.zzavb.add(this.zzawM);
        this.zzavb.add(this.zzawN);
        this.zzavb.add(this.zzawO);
        this.zzavb.add(this.zzawP);
        this.zzavb.add(this.zzawQ);
        this.zzavb.add(this.zzawR);
        this.zzavb.add(this.zzawS);
        this.zzavb.add(this.zzawT);
        this.zzavb.add(this.zzawU);
        this.zzavb.add(this.zzawV);
        this.zzavb.add(this.zzawW);
        this.zzavb.add(this.zzawX);
        this.zzavb.add(this.zzawY);
        this.zzavb.add(this.zzawZ);
        this.zzuM();
    }

    public void zza(zza zza2) {
        this.zzawL = zza2;
    }

    public long zza(zzzc zzzc2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzuz();
        this.zzawM.zza(l2, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", zzyr.zzG(l));
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzzc zzzc2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawN.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzsy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzb(zzzc zzzc2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawP.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzsy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zzc(zzzc zzzc2, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawO.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzsy());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2, long l, int n, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzuz();
        this.zzawQ.zza(l2, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzsy());
            jSONObject2.put("currentTime", zzyr.zzG(l));
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzzc zzzc2, double d, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawR.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzsy());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2, boolean bl, JSONObject jSONObject) throws IOException, zzb {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawS.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzsy());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzuz();
        this.zzawT.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzawK != null) {
                jSONObject.put("mediaSessionId", this.zzawK.zzsy());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2, long[] lArray) throws IOException, zzb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzuz();
        this.zzawU.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzsy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2, TextTrackStyle textTrackStyle) throws IOException, zzb {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzuz();
        this.zzawV.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzsy());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzawJ == 0L) {
            return 0L;
        }
        double d = this.zzawK.getPlaybackRate();
        long l = this.zzawK.getStreamPosition();
        int n = this.zzawK.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        return this.zza(d, l, mediaInfo.getStreamDuration());
    }

    private long zza(double d, long l, long l2) {
        long l3 = this.zzuP.elapsedRealtime() - this.zzawJ;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zzawK;
    }

    public MediaInfo getMediaInfo() {
        return this.zzawK == null ? null : this.zzawK.getMediaInfo();
    }

    public long zza(zzzc zzzc2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzuz();
        this.zzawM.zza(l2, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", zzyr.zzG(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzzc zzzc2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n2 != 0 && n3 != -1) {
            throw new IllegalArgumentException("can not set both currentItemId and currentItemIndexInItemsToInsert");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzuz();
        this.zzawW.zza(l2, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzsy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n2 != 0) {
                jSONObject2.put("currentItemId", n2);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzyr.zzG(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzzc zzzc2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzb {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzuz();
        this.zzawX.zza(l2, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzsy());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", zzyr.zzG(l));
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long zza(zzzc zzzc2, int[] nArray, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawY.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzsy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public long zza(zzzc zzzc2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzb, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzuz();
        this.zzawZ.zza(l, zzzc2);
        this.zzap(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzsy());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzcP(String string2) {
        this.zzapV.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        break;
                    }
                    this.zzawK = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzawT.zzc(l, 0);
                    break;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzapV.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    for (zzzd zzzd2 : this.zzavb) {
                        zzzd2.zzc(l, 2100, jSONObject2);
                    }
                    break;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzawM.zzc(l, 2100, jSONObject3);
                    break;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzawM.zzc(l, 2101, jSONObject4);
                    break;
                }
                case "INVALID_REQUEST": {
                    this.zzapV.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    for (zzzd zzzd3 : this.zzavb) {
                        zzzd3.zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
        }
        catch (JSONException jSONException) {
            this.zzapV.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    private void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzawM.test(l);
        boolean bl2 = this.zzawQ.zzuO() && !this.zzawQ.test(l);
        boolean bl3 = this.zzawR.zzuO() && !this.zzawR.test(l) || this.zzawS.zzuO() && !this.zzawS.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzawK == null) {
            this.zzawK = new MediaStatus(jSONObject);
            this.zzawJ = this.zzuP.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzawK.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzawJ = this.zzuP.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzawJ = this.zzuP.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzawJ = this.zzuP.elapsedRealtime();
            this.onAdBreakStatusUpdated();
        }
        if ((n & 0x40) != 0) {
            this.zzawJ = this.zzuP.elapsedRealtime();
            this.onStatusUpdated();
        }
        for (zzzd zzzd2 : this.zzavb) {
            zzzd2.zzc(l, 0);
        }
    }

    public long zzsy() throws zzb {
        if (this.zzawK == null) {
            throw new zzb();
        }
        return this.zzawK.zzsy();
    }

    private void onStatusUpdated() {
        if (this.zzawL != null) {
            this.zzawL.onStatusUpdated();
        }
    }

    private void onMetadataUpdated() {
        if (this.zzawL != null) {
            this.zzawL.onMetadataUpdated();
        }
    }

    private void onQueueStatusUpdated() {
        if (this.zzawL != null) {
            this.zzawL.onQueueStatusUpdated();
        }
    }

    private void onPreloadStatusUpdated() {
        if (this.zzawL != null) {
            this.zzawL.onPreloadStatusUpdated();
        }
    }

    private void onAdBreakStatusUpdated() {
        if (this.zzawL != null) {
            this.zzawL.onAdBreakStatusUpdated();
        }
    }

    private void zzuM() {
        this.zzawJ = 0L;
        this.zzawK = null;
        for (zzzd zzzd2 : this.zzavb) {
            zzzd2.clear();
        }
    }

    @Override
    public void zzuy() {
        super.zzuy();
        this.zzuM();
    }

    @Override
    public void zzb(long l, int n) {
        for (zzzd zzzd2 : this.zzavb) {
            zzzd2.zzc(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzF(long l) {
        for (zzzd object2 : this.zzavb) {
            object2.zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzzd.zzqS;
        synchronized (object) {
            for (zzzd zzzd2 : this.zzavb) {
                if (!zzzd2.zzuO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static class zzb
    extends Exception {
    }

    public static interface zza {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onAdBreakStatusUpdated();
    }
}

