/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyz;
import com.google.android.gms.internal.zzzg;
import com.google.android.gms.internal.zzzh;
import com.google.android.gms.internal.zzzj;

public class zzzf
implements CastRemoteDisplayApi {
    private static final zzyz zzanA = new zzyz("CastRemoteDisplayApiImpl");
    private Api<?> zzaxf;
    private VirtualDisplay zzaxg;
    private final zzzj zzaxh = new zzzj.zza(){

        @Override
        public void zzcp(int n) {
            zzanA.zzb("onRemoteDisplayEnded", new Object[0]);
            zzzf.this.zzuP();
        }
    };

    public zzzf(Api api) {
        this.zzaxf = api;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient googleApiClient, final String string2) {
        zzanA.zzb("startRemoteDisplay", new Object[0]);
        return googleApiClient.zzb((zzaad.zza)new zzb(googleApiClient){

            @Override
            public void zza(zzzg zzzg2) throws RemoteException {
                zzzg2.zza(new zzb.zza(zzzg2), zzzf.this.zzaxh, string2);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient googleApiClient) {
        zzanA.zzb("stopRemoteDisplay", new Object[0]);
        return googleApiClient.zzb((zzaad.zza)new zzb(this, googleApiClient){

            @Override
            public void zza(zzzg zzzg2) throws RemoteException {
                zzzg2.zza(new zzb.zzb());
            }
        });
    }

    @TargetApi(value=19)
    private void zzuP() {
        if (this.zzaxg != null) {
            Display display = this.zzaxg.getDisplay();
            if (display != null) {
                int n = this.zzaxg.getDisplay().getDisplayId();
                zzanA.zzb(new StringBuilder(38).append("releasing virtual display: ").append(n).toString(), new Object[0]);
            }
            this.zzaxg.release();
            this.zzaxg = null;
        }
    }

    abstract class com.google.android.gms.internal.zzzf$zzb
    extends zzaad.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzzg> {
        public com.google.android.gms.internal.zzzf$zzb(GoogleApiClient googleApiClient) {
            super(zzzf.this.zzaxf, googleApiClient);
        }

        public void zza(zzzg zzzg2) throws RemoteException {
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzu(Status status) {
            return new zzc(status);
        }

        public /* synthetic */ void setResult(Object object) {
            super.zzb((Result)((CastRemoteDisplay.CastRemoteDisplaySessionResult)object));
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzu(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzzf$zza {
            protected zzb() {
                super(zzzf.this);
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzanA.zzb("onDisconnected", new Object[0]);
                zzzf.this.zzuP();
                zzb.this.zzb(new zzc(Status.zzazx));
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzanA.zzb("onError: %d", n);
                zzzf.this.zzuP();
                zzb.this.zzb(new zzc(Status.zzazz));
            }
        }

        @TargetApi(value=19)
        protected final class zza
        extends com.google.android.gms.internal.zzzf$zza {
            private final zzzg zzaxj;

            public zza(zzzg zzzg2) {
                super(zzzf.this);
                this.zzaxj = zzzg2;
            }

            private int zzn(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzanA.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzaxj.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzanA.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                    return;
                }
                zzzf.this.zzuP();
                int n3 = this.zzn(n, n2);
                zzzf.this.zzaxg = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzzf.this.zzaxg == null) {
                    zzanA.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                    return;
                }
                Display display = zzzf.this.zzaxg.getDisplay();
                if (display == null) {
                    zzanA.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                    return;
                }
                try {
                    this.zzaxj.zza(this, zzzf.this.zzaxg.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzanA.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                }
            }

            @Override
            public void zzuR() {
                zzanA.zzb("onConnectedWithDisplay", new Object[0]);
                if (zzzf.this.zzaxg == null) {
                    zzanA.zzc("There is no virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                    return;
                }
                Display display = zzzf.this.zzaxg.getDisplay();
                if (display != null) {
                    zzb.this.zzb(new zzc(display));
                } else {
                    zzanA.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzazz));
                }
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzanA.zzb("onError: %d", n);
                zzzf.this.zzuP();
                zzb.this.zzb(new zzc(Status.zzazz));
            }
        }
    }

    abstract class zza
    extends zzzh.zza {
        zza(zzzf zzzf2) {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int n) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzuR() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzair;
        private final Display zzOq;

        public zzc(Display display) {
            this.zzair = Status.zzazx;
            this.zzOq = display;
        }

        public zzc(Status status) {
            this.zzair = status;
            this.zzOq = null;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzOq;
        }
    }
}

