/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zza {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzag();
    private MediaInfo zzaqi;
    private long zzaqy;
    private int zzaqz;
    private double zzaqA;
    private int zzaqB;
    private int zzaqC;
    private long zzaqD;
    private long zzaqE;
    private double zzaqF;
    private boolean zzaqG;
    private long[] zzaqw;
    private int zzaqH;
    private int zzaqI;
    private String zzaoE;
    private JSONObject zzaoF;
    private int zzaqJ;
    private ArrayList<MediaQueueItem> zzaqK = new ArrayList();
    private boolean zzaqL;
    private AdBreakStatus zzaqM;
    private VideoInfo zzaqN;
    private final SparseArray<Integer> zzaqO = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzaqi = mediaInfo;
        this.zzaqy = l;
        this.zzaqz = n;
        this.zzaqA = d;
        this.zzaqB = n2;
        this.zzaqC = n3;
        this.zzaqD = l2;
        this.zzaqE = l3;
        this.zzaqF = d2;
        this.zzaqG = bl;
        this.zzaqw = lArray;
        this.zzaqH = n4;
        this.zzaqI = n5;
        this.zzaoE = string2;
        if (this.zzaoE != null) {
            try {
                this.zzaoF = new JSONObject(this.zzaoE);
            }
            catch (JSONException jSONException) {
                this.zzaoF = null;
                this.zzaoE = null;
            }
        } else {
            this.zzaoF = null;
        }
        this.zzaqJ = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzaqL = bl2;
        this.zzaqM = adBreakStatus;
        this.zzaqN = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    public final long zzni() {
        return this.zzaqy;
    }

    public int getPlayerState() {
        return this.zzaqB;
    }

    public int getIdleReason() {
        return this.zzaqC;
    }

    public double getPlaybackRate() {
        return this.zzaqA;
    }

    public MediaInfo getMediaInfo() {
        return this.zzaqi;
    }

    public long getStreamPosition() {
        return this.zzaqD;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzaqE & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzaqF;
    }

    public boolean isMute() {
        return this.zzaqG;
    }

    public long[] getActiveTrackIds() {
        return this.zzaqw;
    }

    public JSONObject getCustomData() {
        return this.zzaoF;
    }

    public int getCurrentItemId() {
        return this.zzaqz;
    }

    public int getLoadingItemId() {
        return this.zzaqH;
    }

    public int getPreloadedItemId() {
        return this.zzaqI;
    }

    public int getQueueRepeatMode() {
        return this.zzaqJ;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzaqK;
    }

    public int getQueueItemCount() {
        return this.zzaqK.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzaqL;
    }

    public final void zzV(boolean bl) {
        this.zzaqL = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzaqM;
    }

    public VideoInfo getVideoInfo() {
        return this.zzaqN;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzaqy) {
                                                        this.zzaqy = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zzaqB) {
                                                            this.zzaqB = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzaqC) {
                                                                this.zzaqC = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzaqA != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzaqA = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzaqD) {
                                                        this.zzaqD = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzaqE) {
                                                        this.zzaqE = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzaqF) {
                                                            this.zzaqF = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzaqG) {
                                                            this.zzaqG = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzaqw != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzaqw.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzaqw != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzaqw[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzaqw = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzaqw = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzaoF = jSONObject.getJSONObject("customData");
                                    this.zzaoE = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zzaqi == null || this.zzaqi != null && !this.zzaqi.equals((Object)mediaInfo)) {
                                        this.zzaqi = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzaqz != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzaqz = n10;
                                    n2 |= 2;
                                }
                                if (this.zzaqI != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzaqI = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzaqH != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzaqH = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zzaqi == null ? -1 : this.zzaqi.getStreamType();
                                n3 = this.zzaqH;
                                n7 = this.zzaqC;
                                if (this.zzaqB == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzaqJ;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzaqJ != n6) {
                                mediaStatus.zzaqJ = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzaqz = 0;
                    this.zzaqH = 0;
                    this.zzaqI = 0;
                    if (!this.zzaqK.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzaqJ = 0;
                        mediaStatus2.zzaqK.clear();
                        mediaStatus2.zzaqO.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zzm(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzaqz) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zzaqi).build();
                        mediaQueueItemArray[i].zzm(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzaqK.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzj(jSONObject.optJSONObject("breakStatus"));
        if (this.zzaqM == null && adBreakStatus != null || this.zzaqM != null && !this.zzaqM.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzaqL = bl;
            this.zzaqM = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzn(jSONObject.optJSONObject("videoInfo"));
        if (this.zzaqN == null && videoInfo != null || this.zzaqN != null && !this.zzaqN.equals((Object)videoInfo)) {
            this.zzaqN = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzaqi != null) {
            this.zzaqi.zzk(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzaqO.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzaqK.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzaqK.size()) {
            return null;
        }
        return this.zzaqK.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzaqO.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzaqK.clear();
        this.zzaqO.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzaqK.add(mediaQueueItem);
            this.zzaqO.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzaoF == null != (mediaStatus.zzaoF == null)) {
            return false;
        }
        if (this.zzaqy == mediaStatus.zzaqy && this.zzaqz == mediaStatus.zzaqz && this.zzaqA == mediaStatus.zzaqA && this.zzaqB == mediaStatus.zzaqB && this.zzaqC == mediaStatus.zzaqC && this.zzaqD == mediaStatus.zzaqD && this.zzaqF == mediaStatus.zzaqF && this.zzaqG == mediaStatus.zzaqG && this.zzaqH == mediaStatus.zzaqH && this.zzaqI == mediaStatus.zzaqI && this.zzaqJ == mediaStatus.zzaqJ && Arrays.equals(this.zzaqw, mediaStatus.zzaqw) && zzazq.zza(this.zzaqE, mediaStatus.zzaqE) && zzazq.zza(this.zzaqK, mediaStatus.zzaqK) && zzazq.zza(this.zzaqi, mediaStatus.zzaqi)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzaoF == null || mediaStatus2.zzaoF == null || zzq.zzc((Object)mediaStatus3.zzaoF, (Object)mediaStatus2.zzaoF)) && this.zzaqL == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaqi, this.zzaqy, this.zzaqz, this.zzaqA, this.zzaqB, this.zzaqC, this.zzaqD, this.zzaqE, this.zzaqF, this.zzaqG, Arrays.hashCode(this.zzaqw), this.zzaqH, this.zzaqI, String.valueOf(this.zzaoF), this.zzaqJ, this.zzaqK, this.zzaqL});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzaoE = this.zzaoF == null ? null : this.zzaoF.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzaqy);
        zzd.zzc((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzd.zzc((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzd.zzc((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzd.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzd.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzaqE);
        zzd.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzd.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzd.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzd.zzc((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzd.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzaoE, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, (int)mediaStatus.zzaqJ);
        zzd.zzc((Parcel)parcel2, (int)17, mediaStatus.zzaqK, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzd.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzaqM == null || this.zzaqi == null) {
            return null;
        }
        String string2 = this.zzaqM.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzaqi.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzaqM == null || this.zzaqi == null) {
            return null;
        }
        String string2 = this.zzaqM.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzaqi.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

