/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbi;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzazq;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zza {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbi();
    private float zzarA;
    private int zzarB;
    private int zzHv;
    private int zzarC;
    private int zzarD;
    private int zzarE;
    private int zzarF;
    private int zzarG;
    private String zzarH;
    private int zzarI;
    private int zzarJ;
    private String zzaoE;
    private JSONObject zzaoF;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zzarA = f;
        this.zzarB = n;
        this.zzHv = n2;
        this.zzarC = n3;
        this.zzarD = n4;
        this.zzarE = n5;
        this.zzarF = n6;
        this.zzarG = n7;
        this.zzarH = string2;
        this.zzarI = n8;
        this.zzarJ = n9;
        this.zzaoE = string3;
        if (this.zzaoE != null) {
            try {
                this.zzaoF = new JSONObject(this.zzaoE);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoF = null;
                this.zzaoE = null;
                return;
            }
        }
        this.zzaoF = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zzarA = f;
    }

    public final float getFontScale() {
        return this.zzarA;
    }

    public final void setForegroundColor(int n) {
        this.zzarB = n;
    }

    public final int getForegroundColor() {
        return this.zzarB;
    }

    public final void setBackgroundColor(int n) {
        this.zzHv = n;
    }

    public final int getBackgroundColor() {
        return this.zzHv;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzarC = n;
    }

    public final int getEdgeType() {
        return this.zzarC;
    }

    public final void setEdgeColor(int n) {
        this.zzarD = n;
    }

    public final int getEdgeColor() {
        return this.zzarD;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzarE = n;
    }

    public final int getWindowType() {
        return this.zzarE;
    }

    public final void setWindowColor(int n) {
        this.zzarF = n;
    }

    public final int getWindowColor() {
        return this.zzarF;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzarG = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzarG;
    }

    public final void setFontFamily(String string2) {
        this.zzarH = string2;
    }

    public final String getFontFamily() {
        return this.zzarH;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzarI = n;
    }

    public final int getFontGenericFamily() {
        return this.zzarI;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzarJ = n;
    }

    public final int getFontStyle() {
        return this.zzarJ;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzaoF = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzaoF;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zzsb()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public final void zzl(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zzarA = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzarB = TextTrackStyle.zzcb(jSONObject.optString("foregroundColor"));
        this.zzHv = TextTrackStyle.zzcb(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzarC = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzarC = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzarC = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzarC = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzarC = 4;
            }
        }
        this.zzarD = TextTrackStyle.zzcb(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzarE = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzarE = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzarE = 2;
            }
        }
        this.zzarF = TextTrackStyle.zzcb(jSONObject.optString("windowColor"));
        if (this.zzarE == 2) {
            this.zzarG = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzarH = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzarI = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzarI = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzarI = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzarI = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzarI = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzarI = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzarI = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzarJ = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzarJ = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzarJ = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzarJ = 3;
            }
        }
        this.zzaoF = jSONObject.optJSONObject("customData");
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzarA);
            if (this.zzarB != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zzu(this.zzarB));
            }
            if (this.zzHv != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zzu(this.zzHv));
            }
            switch (this.zzarC) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zzarD != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zzu(this.zzarD));
            }
            switch (this.zzarE) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzarF != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zzu(this.zzarF));
            }
            if (this.zzarE == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzarG);
            }
            if (this.zzarH != null) {
                jSONObject.put("fontFamily", (Object)this.zzarH);
            }
            switch (this.zzarI) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzarJ) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzaoF != null) {
                jSONObject.put("customData", (Object)this.zzaoF);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zzu(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zzcb(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzaoF == null != (textTrackStyle.zzaoF == null)) {
            return false;
        }
        if (this.zzaoF != null && textTrackStyle.zzaoF != null && !zzq.zzc((Object)this.zzaoF, (Object)textTrackStyle.zzaoF)) {
            return false;
        }
        return this.zzarA == textTrackStyle.zzarA && this.zzarB == textTrackStyle.zzarB && this.zzHv == textTrackStyle.zzHv && this.zzarC == textTrackStyle.zzarC && this.zzarD == textTrackStyle.zzarD && this.zzarE == textTrackStyle.zzarE && this.zzarG == textTrackStyle.zzarG && zzazq.zza(this.zzarH, textTrackStyle.zzarH) && this.zzarI == textTrackStyle.zzarI && this.zzarJ == textTrackStyle.zzarJ;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zzarA), this.zzarB, this.zzHv, this.zzarC, this.zzarD, this.zzarE, this.zzarF, this.zzarG, this.zzarH, this.zzarI, this.zzarJ, String.valueOf(this.zzaoF)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoE = this.zzaoF == null ? null : this.zzaoF.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzd.zzc((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzd.zzc((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzd.zzc((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzd.zzc((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzd.zzc((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzd.zzc((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzd.zzc((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzd.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzd.zzc((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzd.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzaoE, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

