/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzayd;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zza
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zzapa;
    private String zzapb;
    private Inet4Address zzapc;
    private String zzapd;
    private String zzape;
    private String zzapf;
    private int zzapg;
    private List<WebImage> zzaph;
    private int zzapi;
    private int zzLg;
    private String zzapj;
    private String zzapk;
    private int zzapl;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4) {
        this.zzapa = CastDevice.zzbX(string);
        this.zzapb = CastDevice.zzbX(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzapb)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzapb);
                if (inetAddress instanceof Inet4Address) {
                    this.zzapc = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string8 = this.zzapb;
                String string9 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string8).length() + String.valueOf(string9).length()).append("Unable to convert host address (").append(string8).append(") to ipaddress: ").append(string9).toString());
            }
        }
        this.zzapd = CastDevice.zzbX(string3);
        this.zzape = CastDevice.zzbX(string4);
        this.zzapf = CastDevice.zzbX(string5);
        this.zzapg = n;
        this.zzaph = arrayList != null ? arrayList : new ArrayList();
        this.zzapi = n2;
        this.zzLg = n3;
        this.zzapj = CastDevice.zzbX(string6);
        this.zzapk = string7;
        this.zzapl = n4;
    }

    public String getDeviceId() {
        if (this.zzapa.startsWith("__cast_nearby__")) {
            return this.zzapa.substring(16);
        }
        return this.zzapa;
    }

    public Inet4Address getIpAddress() {
        return this.zzapc;
    }

    public String getFriendlyName() {
        return this.zzapd;
    }

    public String getModelName() {
        return this.zzape;
    }

    public String getDeviceVersion() {
        return this.zzapf;
    }

    public int getServicePort() {
        return this.zzapg;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzaph);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzaph.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzaph.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzaph) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzaph.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzaph.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzapi & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzapd, this.zzapa);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castDevice.zzapa, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)castDevice.zzapb, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzd.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)castDevice.zzapi);
        zzd.zzc((Parcel)parcel2, (int)10, (int)castDevice.zzLg);
        zzd.zza((Parcel)parcel2, (int)11, (String)castDevice.zzapj, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)castDevice.zzapk, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)castDevice.zzapl);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzapa == null) {
            return castDevice.zzapa == null;
        }
        return zzayd.zza(this.zzapa, castDevice.zzapa) && zzayd.zza(this.zzapc, castDevice.zzapc) && zzayd.zza(this.zzape, castDevice.zzape) && zzayd.zza(this.zzapd, castDevice.zzapd) && zzayd.zza(this.zzapf, castDevice.zzapf) && this.zzapg == castDevice.zzapg && zzayd.zza(this.zzaph, castDevice.zzaph) && this.zzapi == castDevice.zzapi && this.zzLg == castDevice.zzLg && zzayd.zza(this.zzapj, castDevice.zzapj) && zzayd.zza(this.zzapl, castDevice.zzapl);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzapa == null) {
            return castDevice.zzapa == null;
        }
        return zzayd.zza(this.zzapa, castDevice.zzapa);
    }

    public int hashCode() {
        if (this.zzapa == null) {
            return 0;
        }
        return this.zzapa.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzapa.startsWith("__cast_nearby__");
    }

    private static String zzbX(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

