/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.games;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.internal.zzawx;
import org.json.JSONObject;

public final class GameManagerClient {
    public static final int STATUS_INCORRECT_VERSION = 2150;
    public static final int STATUS_TOO_MANY_PLAYERS = 2151;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_DROPPED = 1;
    public static final int PLAYER_STATE_QUIT = 2;
    public static final int PLAYER_STATE_AVAILABLE = 3;
    public static final int PLAYER_STATE_READY = 4;
    public static final int PLAYER_STATE_IDLE = 5;
    public static final int PLAYER_STATE_PLAYING = 6;
    public static final int LOBBY_STATE_UNKNOWN = 0;
    public static final int LOBBY_STATE_OPEN = 1;
    public static final int LOBBY_STATE_CLOSED = 2;
    public static final int GAMEPLAY_STATE_UNKNOWN = 0;
    public static final int GAMEPLAY_STATE_LOADING = 1;
    public static final int GAMEPLAY_STATE_RUNNING = 2;
    public static final int GAMEPLAY_STATE_PAUSED = 3;
    public static final int GAMEPLAY_STATE_SHOWING_INFO_SCREEN = 4;
    private final zzawx zzawQ;

    private GameManagerClient(zzawx zzawx2) {
        this.zzawQ = zzawx2;
    }

    public static PendingResult<GameManagerInstanceResult> getInstanceFor(GoogleApiClient googleApiClient, String string2) throws IllegalArgumentException {
        zzawx zzawx2 = new zzawx(googleApiClient, string2, Cast.CastApi);
        GameManagerClient gameManagerClient = new GameManagerClient(zzawx2);
        return zzawx2.zza(gameManagerClient);
    }

    public final PendingResult<GameManagerResult> sendPlayerAvailableRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 3, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerAvailableRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 3, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerReadyRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 4, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerReadyRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 4, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerPlayingRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 6, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerPlayingRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 6, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerIdleRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 5, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerIdleRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 5, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerQuitRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 2, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendPlayerQuitRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 2, jSONObject);
    }

    private final PendingResult<GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        return this.zzawQ.zza(string2, n, jSONObject);
    }

    public final PendingResult<GameManagerResult> sendGameRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.sendGameRequest(this.getLastUsedPlayerId(), jSONObject);
    }

    public final PendingResult<GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zzawQ.sendGameRequest(string2, jSONObject);
    }

    public final void sendGameMessage(JSONObject jSONObject) throws IllegalStateException {
        this.sendGameMessage(this.getLastUsedPlayerId(), jSONObject);
    }

    public final void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzawQ.sendGameMessage(string2, jSONObject);
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        return this.zzawQ.getCurrentState();
    }

    public final String getLastUsedPlayerId() throws IllegalStateException {
        return this.zzawQ.getLastUsedPlayerId();
    }

    public final void setListener(Listener listener) {
        this.zzawQ.setListener(listener);
    }

    public final void dispose() {
        this.zzawQ.dispose();
    }

    public final boolean isDisposed() {
        return this.zzawQ.isDisposed();
    }

    public final void setSessionLabel(String string2) {
        this.zzawQ.setSessionLabel(string2);
    }

    public static interface GameManagerResult
    extends Result {
        public String getPlayerId();

        public long getRequestId();

        public JSONObject getExtraMessageData();
    }

    public static interface GameManagerInstanceResult
    extends Result {
        public GameManagerClient getGameManagerClient();
    }

    public static interface Listener {
        public void onStateChanged(GameManagerState var1, GameManagerState var2);

        public void onGameMessageReceived(String var1, JSONObject var2);
    }
}

