/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzaye;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakStatus
extends zza {
    public static final Parcelable.Creator<AdBreakStatus> CREATOR = new zzc();
    public static final int AD_BREAK_CLIP_NOT_SKIPPABLE = -1;
    private final long zzaoH;
    private final long zzaoI;
    private final String zzaoJ;
    private final String zzaoK;
    private final long zzaoL;

    AdBreakStatus(long l, long l2, String string, String string2, long l3) {
        this.zzaoH = l;
        this.zzaoI = l2;
        this.zzaoJ = string;
        this.zzaoK = string2;
        this.zzaoL = l3;
    }

    public String getBreakId() {
        return this.zzaoJ;
    }

    public String getBreakClipId() {
        return this.zzaoK;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zzaoH;
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzaoI;
    }

    public long getWhenSkippableInMs() {
        return this.zzaoL;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakStatus adBreakStatus = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (long)adBreakStatus.getCurrentBreakTimeInMs());
        zzd.zza((Parcel)parcel2, (int)3, (long)adBreakStatus.getCurrentBreakClipTimeInMs());
        zzd.zza((Parcel)parcel2, (int)4, (String)adBreakStatus.getBreakId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)adBreakStatus.getBreakClipId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)adBreakStatus.getWhenSkippableInMs());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaoH, this.zzaoI, this.zzaoJ, this.zzaoK, this.zzaoL});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakStatus)) {
            return false;
        }
        AdBreakStatus adBreakStatus = (AdBreakStatus)((Object)object);
        return this.zzaoH == adBreakStatus.zzaoH && this.zzaoI == adBreakStatus.zzaoI && zzaye.zza(this.zzaoJ, adBreakStatus.zzaoJ) && zzaye.zza(this.zzaoK, adBreakStatus.zzaoK) && this.zzaoL == adBreakStatus.zzaoL;
    }

    static AdBreakStatus zzj(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("currentBreakTime") || !jSONObject.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l = (long)((double)jSONObject.getLong("currentBreakTime") * 1000.0);
            long l2 = (long)((double)jSONObject.getLong("currentBreakClipTime") * 1000.0);
            String string = jSONObject.optString("breakId", null);
            String string2 = jSONObject.optString("breakClipId", null);
            long l3 = jSONObject.optLong("whenSkippable", -1L);
            if (l3 != -1L) {
                l3 = (long)((double)l3 * 1000.0);
            }
            return new AdBreakStatus(l, l2, string, string2, l3);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

