/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.zzp;
import com.google.android.gms.cast.zzq;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.cast.zzs;
import com.google.android.gms.cast.zzt;
import com.google.android.gms.cast.zzu;
import com.google.android.gms.cast.zzv;
import com.google.android.gms.cast.zzw;
import com.google.android.gms.cast.zzx;
import com.google.android.gms.cast.zzy;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzayo;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzayo zzapq = new zzayo("CastRemoteDisplayLocalService");
    private static final int zzapr = R.id.cast_notification_id;
    private static final Object zzaps = new Object();
    private static AtomicBoolean zzapt = new AtomicBoolean(false);
    private GoogleApiClient zzapu;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzapv;
    private String zzaoM;
    private Callbacks zzapw;
    private zzb zzapx;
    private NotificationSettings zzapy;
    private Notification mNotification;
    private boolean zzapz;
    private PendingIntent zzapA;
    private CastDevice zzapB;
    private Display zzPO;
    private Context zzapC;
    private ServiceConnection zzapD;
    private Handler mHandler;
    private MediaRouter zzapE;
    private boolean zzapF = false;
    private final MediaRouter.Callback zzapG = new zzp(this);
    private static CastRemoteDisplayLocalService zzapH;
    private final IBinder zzapI = new zza(null);

    public IBinder onBind(Intent intent) {
        this.zzbp("onBind");
        return this.zzapI;
    }

    public void onCreate() {
        this.zzbp("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed((Runnable)new zzr(this), 100L);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzbp("onStartCommand");
        this.zzapF = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzapq.zzaa(true);
    }

    protected Display getDisplay() {
        return this.zzPO;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzaps;
        synchronized (object) {
            return zzapH;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(@NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, @NonNull String string2, @NonNull CastDevice castDevice, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        zzapq.zzb("Starting Service", new Object[0]);
        Object object = zzaps;
        synchronized (object) {
            if (zzapH != null) {
                zzapq.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzR(true);
            }
        }
        Class<? extends CastRemoteDisplayLocalService> clazz2 = clazz;
        Context context2 = context;
        try {
            ComponentName componentName = new ComponentName(context2, clazz2);
            ServiceInfo serviceInfo = context2.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
        zzbo.zzb((Object)context, (Object)"activityContext is required.");
        zzbo.zzb(clazz, (Object)"serviceClass is required.");
        zzbo.zzb((Object)string2, (Object)"applicationId is required.");
        zzbo.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzbo.zzb((Object)options, (Object)"options is required.");
        zzbo.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbo.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzapQ == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzapt.getAndSet(true)) {
            zzapq.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, (ServiceConnection)new zzs(string2, castDevice, options, notificationSettings, context, callbacks), 64);
    }

    private final void zzQ(boolean bl) {
        this.zzbp("Stopping Service");
        zzbo.zzcz((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzapE != null) {
            this.zzbp("Setting default route");
            this.zzapE.selectRoute(this.zzapE.getDefaultRoute());
        }
        if (this.zzapx != null) {
            this.zzbp("Unregistering notification receiver");
            this.unregisterReceiver(this.zzapx);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzbp("stopRemoteDisplaySession");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.zzbp("stopRemoteDisplay");
        if (castRemoteDisplayLocalService2.zzapu == null || !castRemoteDisplayLocalService2.zzapu.isConnected()) {
            zzapq.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
        } else {
            CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(castRemoteDisplayLocalService2.zzapu).setResultCallback((ResultCallback)new zzx(castRemoteDisplayLocalService2));
        }
        castRemoteDisplayLocalService.onDismissPresentation();
        castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zzbp("Stopping the remote display Service");
        castRemoteDisplayLocalService.stopForeground(true);
        castRemoteDisplayLocalService.stopSelf();
        castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzapE != null) {
            zzbo.zzcz((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            castRemoteDisplayLocalService.zzbp("removeMediaRouterCallback");
            castRemoteDisplayLocalService.zzapE.removeCallback(castRemoteDisplayLocalService.zzapG);
        }
        if (this.zzapu != null) {
            this.zzapu.disconnect();
            this.zzapu = null;
        }
        if (this.zzapC != null && this.zzapD != null) {
            try {
                this.zzapC.unbindService(this.zzapD);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbp("No need to unbind service, already unbound");
            }
            this.zzapD = null;
            this.zzapC = null;
        }
        this.zzaoM = null;
        this.zzapu = null;
        this.mNotification = null;
        this.zzPO = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzR(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzapq.zzb("Stopping Service", new Object[0]);
        zzapt.set(false);
        Object object = zzaps;
        synchronized (object) {
            if (zzapH == null) {
                zzapq.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzapH;
            zzapH = null;
        }
        boolean bl2 = bl;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        if (castRemoteDisplayLocalService2.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService2.mHandler.post((Runnable)new zzt(castRemoteDisplayLocalService2, bl2));
                return;
            }
            castRemoteDisplayLocalService2.zzQ(bl2);
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzR(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzbo.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbo.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post((Runnable)new zzu(this, notificationSettings));
    }

    private final void zza(NotificationSettings notificationSettings) {
        zzbo.zzcz((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzapy == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzapz) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzapQ != null) {
                this.zzapy.zzapQ = notificationSettings.zzapQ;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzapR)) {
                this.zzapy.zzapR = notificationSettings.zzapR;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzapS)) {
                this.zzapy.zzapS = notificationSettings.zzapS;
            }
            this.mNotification = this.zzS(true);
        } else {
            zzbo.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzapy.mNotification = this.mNotification;
        }
        this.startForeground(zzapr, this.mNotification);
    }

    private final void zza(Display display) {
        this.zzPO = display;
        if (this.zzapz) {
            this.mNotification = this.zzS(true);
            this.startForeground(zzapr, this.mNotification);
        }
        if (this.zzapw != null) {
            this.zzapw.onRemoteDisplaySessionStarted(this);
            this.zzapw = null;
        }
        this.onCreatePresentation(this.zzPO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbp("startRemoteDisplaySession");
        zzbo.zzcz((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzaps;
        synchronized (object) {
            if (zzapH != null) {
                zzapq.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzapH = this;
        }
        this.zzapw = callbacks;
        this.zzaoM = string2;
        this.zzapB = castDevice;
        this.zzapC = context;
        this.zzapD = serviceConnection;
        this.zzapE = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzaoM)).build();
        this.zzbp("addMediaRouterCallback");
        this.zzapE.addCallback((MediaRouteSelector)object, this.zzapG, 4);
        this.zzapv = new zzv(this);
        this.mNotification = notificationSettings.mNotification;
        this.zzapx = new zzb(null);
        this.registerReceiver(this.zzapx, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzapy = new NotificationSettings(notificationSettings, null);
        if (this.zzapy.mNotification == null) {
            this.zzapz = true;
            this.mNotification = this.zzS(false);
        } else {
            this.zzapz = false;
            this.mNotification = this.zzapy.mNotification;
        }
        this.startForeground(zzapr, this.mNotification);
        Options options2 = options;
        CastDevice castDevice2 = castDevice;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice2, castRemoteDisplayLocalService.zzapv);
        if (options2 != null) {
            builder.setConfigPreset(options2.zzapn);
        }
        zzy zzy2 = new zzy(castRemoteDisplayLocalService);
        zzq zzq2 = new zzq(castRemoteDisplayLocalService);
        this.zzapu = new GoogleApiClient.Builder((Context)castRemoteDisplayLocalService, (GoogleApiClient.ConnectionCallbacks)zzy2, (GoogleApiClient.OnConnectionFailedListener)zzq2).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
        this.zzapu.connect();
        if (this.zzapw != null) {
            this.zzapw.onServiceCreated(this);
        }
        return true;
    }

    private final void zznd() {
        this.zzbp("startRemoteDisplay");
        if (this.zzapu == null || !this.zzapu.isConnected()) {
            zzapq.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzapu, this.zzaoM).setResultCallback((ResultCallback)new zzw(this));
    }

    private final void zzne() {
        if (this.zzapw != null) {
            this.zzapw.onRemoteDisplaySessionError(new Status(2200));
            this.zzapw = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private final Notification zzS(boolean bl) {
        int n;
        int n2;
        this.zzbp("createDefaultNotification");
        String string2 = this.zzapy.zzapR;
        String string3 = this.zzapy.zzapS;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo()) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzapB.getFriendlyName()}) : string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzapy.zzapQ).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzapA == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(castRemoteDisplayLocalService.zzapC.getPackageName());
            castRemoteDisplayLocalService.zzapA = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x10000000);
        }
        return builder.addAction(17301560, (CharSequence)string6, castRemoteDisplayLocalService.zzapA).build();
    }

    private final void zzbp(String string2) {
        zzapq.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private final void zzbs(String string2) {
        zzapq.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzbp(string2);
    }

    static /* synthetic */ CastDevice zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzapB;
    }

    static /* synthetic */ boolean zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzapF;
    }

    static /* synthetic */ void zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzbs(string2);
    }

    static /* synthetic */ boolean zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        return castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, serviceConnection, callbacks);
    }

    static /* synthetic */ AtomicBoolean zzng() {
        return zzapt;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzQ(bl);
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        castRemoteDisplayLocalService.zza(notificationSettings);
    }

    static /* synthetic */ void zzT(boolean bl) {
        CastRemoteDisplayLocalService.zzR(false);
    }

    static /* synthetic */ void zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zzne();
    }

    static /* synthetic */ Object zznh() {
        return zzaps;
    }

    static /* synthetic */ CastRemoteDisplayLocalService zzni() {
        return zzapH;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zza(display);
    }

    static /* synthetic */ Context zzd(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzapC;
    }

    static /* synthetic */ ServiceConnection zze(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzapD;
    }

    static /* synthetic */ ServiceConnection zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzapD = null;
        return null;
    }

    static /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzapC = null;
        return null;
    }

    static /* synthetic */ Display zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzPO = null;
        return null;
    }

    static /* synthetic */ void zzf(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zznd();
    }

    final class zza
    extends Binder {
        private zza() {
        }

        /* synthetic */ zza(zzp zzp2) {
            this();
        }
    }

    static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public final void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzapq.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }

        /* synthetic */ zzb(zzp zzp2) {
            this();
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int zzapn = 2;

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzapn = n;
        }

        public int getConfigPreset() {
            return this.zzapn;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzapQ;
        private String zzapR;
        private String zzapS;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzapQ = notificationSettings.zzapQ;
            this.zzapR = notificationSettings.zzapR;
            this.zzapS = notificationSettings.zzapS;
        }

        /* synthetic */ NotificationSettings(zzp zzp2) {
            this();
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzp zzp2) {
            this(notificationSettings);
        }

        public static final class Builder {
            private NotificationSettings zzapT = new NotificationSettings(null);

            public final Builder setNotification(Notification notification) {
                this.zzapT.mNotification = notification;
                return this;
            }

            public final Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzapT.zzapQ = pendingIntent;
                return this;
            }

            public final Builder setNotificationTitle(String string2) {
                this.zzapT.zzapR = string2;
                return this;
            }

            public final Builder setNotificationText(String string2) {
                this.zzapT.zzapS = string2;
                return this;
            }

            public final NotificationSettings build() {
                if (this.zzapT.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzapT.zzapR)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzapT.zzapS)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzapT.zzapQ != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzapT.zzapR) && TextUtils.isEmpty((CharSequence)this.zzapT.zzapS) && this.zzapT.zzapQ == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzapT;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

