/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzawz;
import com.google.android.gms.internal.zzaxb;
import com.google.android.gms.internal.zzaxc;
import com.google.android.gms.internal.zzaxd;
import com.google.android.gms.internal.zzaxl;
import com.google.android.gms.internal.zzaxm;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzaxp;
import com.google.android.gms.internal.zzaxt;
import com.google.android.gms.internal.zzaye;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayt;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzbay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzawy
extends zzaxt {
    private static String NAMESPACE = zzaye.zzcj("com.google.cast.games");
    private static final zzayo zzapq = new zzayo("GameManagerChannel");
    private final Map<String, String> zzawR = new ConcurrentHashMap<String, String>();
    private final List<zzayu> zzawS;
    private final SharedPreferences zzBT;
    private final String zzawT;
    private final Cast.CastApi zzasb;
    private final GoogleApiClient zzXj;
    private zzaxl zzawU;
    private boolean zzawV = false;
    private GameManagerState zzawW;
    private GameManagerState zzawX;
    private String zzawY;
    private JSONObject zzawZ;
    private long zzaxa = 0L;
    private GameManagerClient.Listener zzaxb;
    private final zze zzvw;
    private String zzaxc;

    public zzawy(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzvw = zzi.zzrY();
        this.zzawS = new ArrayList<zzayu>();
        this.zzawT = string2;
        this.zzasb = castApi;
        this.zzXj = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzBT = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzawX = null;
        this.zzawW = new zzaxn(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzXj.zze((zzbay)new zzawz(this, gameManagerClient));
    }

    public final synchronized void dispose() throws IllegalStateException {
        if (this.zzawV) {
            return;
        }
        this.zzawW = null;
        this.zzawX = null;
        this.zzawY = null;
        this.zzawZ = null;
        this.zzawV = true;
        try {
            this.zzasb.removeMessageReceivedCallbacks(this.zzXj, this.getNamespace());
            return;
        }
        catch (IOException iOException) {
            zzapq.zzf("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzot();
        return this.zzXj.zze((zzbay)new zzaxb(this, n, string2, jSONObject));
    }

    public final synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzot();
        long l = ++this.zzaxa;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzasb.sendMessage(this.zzXj, this.getNamespace(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzot();
        return this.zzXj.zze((zzbay)new zzaxc(this, string2, jSONObject));
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzot();
        return this.zzawW;
    }

    public final synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzot();
        return this.zzaxc;
    }

    private final synchronized String zzcg(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzawR.get(string2);
    }

    public final synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzaxb = listener;
    }

    @Override
    public final void zzch(String string2) {
        int n;
        zzaxm zzaxm2;
        zzapq.zzb("message received: %s", string2);
        try {
            zzaxm2 = zzaxm.zzo(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zzapq.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzaxm2 == null) {
            zzapq.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzaxm2.zzawU == null || this.isDisposed()) {
            return;
        }
        boolean bl = zzaxm2.zzaxt == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzaxm2.zzaxB)) {
            this.zzawR.put(zzaxm2.zzaxn, zzaxm2.zzaxB);
            this.zzou();
        }
        if (zzaxm2.zzaxu == 0) {
            this.zza(zzaxm2);
        } else {
            zzapq.zzf("Not updating from game message because the message contains error code: %d", zzaxm2.zzaxu);
        }
        int n2 = zzaxm2.zzaxu;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zzapq.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zzb(zzaxm2.zzaxo, n, zzaxm2);
        }
        if (this.isInitialized() && n == 0) {
            zzawy zzawy2 = this;
            if (zzawy2.zzaxb != null) {
                if (zzawy2.zzawX != null && !zzawy2.zzawW.equals(zzawy2.zzawX)) {
                    zzawy2.zzaxb.onStateChanged(zzawy2.zzawW, zzawy2.zzawX);
                }
                if (zzawy2.zzawZ != null && zzawy2.zzawY != null) {
                    zzawy2.zzaxb.onGameMessageReceived(zzawy2.zzawY, zzawy2.zzawZ);
                }
            }
            zzawy2.zzawX = null;
            zzawy2.zzawY = null;
            zzawy2.zzawZ = null;
        }
    }

    public final synchronized boolean isDisposed() {
        return this.zzawV;
    }

    private final synchronized boolean isInitialized() {
        return this.zzawU != null;
    }

    @Override
    public final void zzc(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzayu> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzayu.zzrl;
        synchronized (object) {
            Iterator<zzayu> iterator2 = this.zzawS.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzoO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzot() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzayt zzayt2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzaxa, string2, n, jSONObject)) == null) {
            zzayt2.zza(-1L, 2001, null);
            zzapq.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzayu zzayu2 = new zzayu(this.zzvw, 30000L);
        zzayu2.zza(l, zzayt2);
        this.zzawS.add(zzayu2);
        this.zzZ(true);
        this.zzasb.sendMessage(this.zzXj, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzaxd(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzcg(string2));
        }
        catch (JSONException jSONException) {
            zzapq.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzaxm zzaxm2) {
        boolean bl = zzaxm2.zzaxt == 1;
        this.zzawX = this.zzawW;
        if (bl && zzaxm2.zzawU != null) {
            this.zzawU = zzaxm2.zzawU;
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzaxp zzaxp2 : zzaxm2.zzaxy) {
            String string2 = zzaxp2.getPlayerId();
            zzaxo zzaxo2 = new zzaxo(string2, zzaxp2.getPlayerState(), zzaxp2.getPlayerData(), this.zzawR.containsKey(string2));
            arrayList.add(zzaxo2);
        }
        this.zzawW = new zzaxn(zzaxm2.zzaxx, zzaxm2.zzaxw, zzaxm2.zzaxA, zzaxm2.zzaxz, arrayList, this.zzawU.zzox(), this.zzawU.getMaxPlayers());
        PlayerInfo playerInfo = this.zzawW.getPlayer(zzaxm2.zzaxn);
        if (playerInfo != null && playerInfo.isControllable() && zzaxm2.zzaxt == 2) {
            this.zzawY = zzaxm2.zzaxn;
            this.zzawZ = zzaxm2.zzaxp;
        }
    }

    private final void zzb(long l, int n, Object object) {
        Iterator<zzayu> iterator = this.zzawS.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzou() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzawT);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzawR));
            this.zzBT.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zzapq.zzf("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzov() {
        String string2 = this.zzBT.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzawT.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzawR.put(string4, jSONObject2.getString(string4));
                }
                this.zzaxa = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zzapq.zzf("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzawy zzawy2) {
        return zzawy2.zzXj;
    }

    static /* synthetic */ Cast.CastApi zzb(zzawy zzawy2) {
        return zzawy2.zzasb;
    }

    static /* synthetic */ void zzc(zzawy zzawy2) {
        zzawy2.zzov();
    }

    static /* synthetic */ void zzd(zzawy zzawy2) {
        zzawy2.zzou();
    }

    static /* synthetic */ void zza(zzawy zzawy2, String string2, int n, JSONObject jSONObject, zzayt zzayt2) {
        zzawy2.zza(string2, n, jSONObject, zzayt2);
    }

    static /* synthetic */ zzayo zzow() {
        return zzapq;
    }

    static /* synthetic */ zzaxl zza(zzawy zzawy2, zzaxl zzaxl2) {
        zzawy2.zzawU = null;
        return null;
    }

    static /* synthetic */ String zza(zzawy zzawy2, String string2) {
        zzawy2.zzaxc = string2;
        return zzawy2.zzaxc;
    }
}

