/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzayo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzayv {
    private static final zzayo zzapq = new zzayo("MetadataUtils");
    private static final String[] zzayU = new String[]{"Z", "+hh", "+hhmm", "+hh:mm"};
    private static final String zzayV;

    public static void zza(List<WebImage> list, JSONObject jSONObject) {
        try {
            list.clear();
            JSONArray jSONArray = jSONObject.getJSONArray("images");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                try {
                    list.add(new WebImage(jSONObject2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    public static void zza(JSONObject jSONObject, List<WebImage> list) {
        if (list != null && !list.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (WebImage webImage : list) {
                jSONArray.put((Object)webImage.toJson());
            }
            try {
                jSONObject.put("images", (Object)jSONArray);
                return;
            }
            catch (JSONException jSONException) {}
        }
    }

    public static String zza(Calendar calendar) {
        if (calendar == null) {
            zzapq.zzb("Calendar object cannot be null", new Object[0]);
            return null;
        }
        String string2 = zzayV;
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string2 = "yyyyMMdd";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String string3 = simpleDateFormat.format(calendar.getTime());
        if (string3.endsWith("+0000")) {
            string3 = string3.replace("+0000", zzayU[0]);
        }
        return string3;
    }

    public static Calendar zzco(String string2) {
        Date date;
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzapq.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        String string3 = zzayv.zzcp(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzapq.zzb("Invalid date format", new Object[0]);
            return null;
        }
        String string4 = zzayv.zzcq(string2);
        String string5 = "yyyyMMdd";
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            object = String.valueOf(string3);
            string3 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string4).length()).append((String)object).append("T").append(string4).toString();
            string5 = string4.length() == 6 ? "yyyyMMdd'T'HHmmss" : zzayV;
        }
        object = GregorianCalendar.getInstance();
        try {
            date = new SimpleDateFormat(string5).parse(string3);
        }
        catch (ParseException parseException) {
            zzapq.zzb("Error parsing string: %s", parseException.getMessage());
            return null;
        }
        ((Calendar)object).setTime(date);
        return object;
    }

    private static String zzcp(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzapq.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        try {
            return string2.substring(0, 8);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzapq.zze("Error extracting the date: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
    }

    private static String zzcq(String string2) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzapq.zzb("string is empty or null", new Object[0]);
            return null;
        }
        int n = string2.indexOf(84);
        int n2 = n;
        ++n2;
        if (n != 8) {
            zzapq.zzb("T delimeter is not found", new Object[0]);
            return null;
        }
        try {
            string3 = string2.substring(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzapq.zzb("Error extracting the time substring: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
        if (string3.length() == 6) {
            return string3;
        }
        switch (string3.charAt(6)) {
            case 'Z': {
                if (string3.length() == 6 + zzayU[0].length()) {
                    String string4 = String.valueOf(string3.substring(0, string3.length() - 1));
                    String string5 = String.valueOf("+0000");
                    if (string5.length() != 0) {
                        return string4.concat(string5);
                    }
                    return new String(string4);
                }
                return null;
            }
            case '+': 
            case '-': {
                int n3 = string3.length();
                if (!(n3 == 6 + zzayU[1].length() || n3 == 6 + zzayU[2].length() || n3 == 6 + zzayU[3].length())) break;
                return string3.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
            }
        }
        return null;
    }

    static {
        String string2 = String.valueOf("yyyyMMdd'T'HHmmss");
        String string3 = String.valueOf(zzayU[0]);
        zzayV = string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }
}

