/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzae;
import com.google.android.gms.cast.zzaf;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzaye;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zza {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzaf();
    private MediaInfo zzaqo;
    private int zzaqp;
    private boolean zzaqq;
    private double zzaqr;
    private double zzaqs;
    private double zzaqt;
    private long[] zzaqu;
    private String zzaoC;
    private JSONObject zzaoD;

    MediaQueueItem(MediaInfo mediaInfo, int n, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.zzaqo = mediaInfo;
        this.zzaqp = n;
        this.zzaqq = bl;
        this.zzaqr = d;
        this.zzaqs = d2;
        this.zzaqt = d3;
        this.zzaqu = lArray;
        this.zzaoC = string2;
        if (this.zzaoC != null) {
            try {
                this.zzaoD = new JSONObject(this.zzaoC);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoD = null;
                this.zzaoC = null;
                return;
            }
        }
        this.zzaoD = null;
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzm(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzaqo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzaoD = mediaQueueItem.getCustomData();
    }

    public final boolean zzm(JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzaqo = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzaqp != (n = jSONObject.getInt("itemId"))) {
            this.zzaqp = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzaqq != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzaqq = n;
            bl = true;
        }
        if (jSONObject.has("startTime")) {
            double d;
            double d2 = jSONObject.getDouble("startTime");
            if (Math.abs(d - this.zzaqr) > 1.0E-7) {
                this.zzaqr = d2;
                bl = true;
            }
        }
        if (jSONObject.has("playbackDuration")) {
            double d;
            double d3 = jSONObject.getDouble("playbackDuration");
            if (Math.abs(d - this.zzaqs) > 1.0E-7) {
                this.zzaqs = d3;
                bl = true;
            }
        }
        if (jSONObject.has("preloadTime")) {
            double d;
            double d4 = jSONObject.getDouble("preloadTime");
            if (Math.abs(d - this.zzaqt) > 1.0E-7) {
                this.zzaqt = d4;
                bl = true;
            }
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzaqu == null) {
                bl2 = true;
            } else if (this.zzaqu.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzaqu[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzaqu = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzaoD = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzaqo;
    }

    public int getItemId() {
        return this.zzaqp;
    }

    final void zzV(int n) {
        this.zzaqp = 0;
    }

    public boolean getAutoplay() {
        return this.zzaqq;
    }

    final void zzU(boolean bl) {
        this.zzaqq = bl;
    }

    public double getStartTime() {
        return this.zzaqr;
    }

    final void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzaqr = d;
    }

    public double getPlaybackDuration() {
        return this.zzaqs;
    }

    final void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzaqs = d;
    }

    public double getPreloadTime() {
        return this.zzaqt;
    }

    final void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzaqt = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzaqu;
    }

    final void zza(long[] lArray) {
        this.zzaqu = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzaoD;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoD = jSONObject;
    }

    final void zznj() throws IllegalArgumentException {
        if (this.zzaqo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzaqr) || this.zzaqr < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzaqs)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzaqt) || this.zzaqt < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzaqo.toJson());
            if (this.zzaqp != 0) {
                jSONObject.put("itemId", this.zzaqp);
            }
            jSONObject.put("autoplay", this.zzaqq);
            jSONObject.put("startTime", this.zzaqr);
            if (this.zzaqs != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzaqs);
            }
            jSONObject.put("preloadTime", this.zzaqt);
            if (this.zzaqu != null) {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = this.zzaqu;
                int n = this.zzaqu.length;
                for (int i = 0; i < n; ++i) {
                    long l = lArray[i];
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzaoD != null) {
                jSONObject.put("customData", (Object)this.zzaoD);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzaoD == null != (mediaQueueItem.zzaoD == null)) {
            return false;
        }
        if (this.zzaoD != null && mediaQueueItem.zzaoD != null && !zzo.zzc((Object)this.zzaoD, (Object)mediaQueueItem.zzaoD)) {
            return false;
        }
        return zzaye.zza(this.zzaqo, mediaQueueItem.zzaqo) && this.zzaqp == mediaQueueItem.zzaqp && this.zzaqq == mediaQueueItem.zzaqq && this.zzaqr == mediaQueueItem.zzaqr && this.zzaqs == mediaQueueItem.zzaqs && this.zzaqt == mediaQueueItem.zzaqt && Arrays.equals(this.zzaqu, mediaQueueItem.zzaqu);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaqo, this.zzaqp, this.zzaqq, this.zzaqr, this.zzaqs, this.zzaqt, Arrays.hashCode(this.zzaqu), String.valueOf(this.zzaoD)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzaoC = this.zzaoD == null ? null : this.zzaoD.toString();
        Parcel parcel2 = parcel;
        MediaQueueItem mediaQueueItem = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaQueueItem.getMedia(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaQueueItem.getItemId());
        zzd.zza((Parcel)parcel2, (int)4, (boolean)mediaQueueItem.getAutoplay());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaQueueItem.getStartTime());
        zzd.zza((Parcel)parcel2, (int)6, (double)mediaQueueItem.getPlaybackDuration());
        zzd.zza((Parcel)parcel2, (int)7, (double)mediaQueueItem.getPreloadTime());
        zzd.zza((Parcel)parcel2, (int)8, (long[])mediaQueueItem.getActiveTrackIds(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaQueueItem.zzaoC, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzae zzae2) throws IllegalArgumentException {
        this(mediaInfo);
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzae zzae2) throws IllegalArgumentException {
        this(mediaQueueItem);
    }

    public static class Builder {
        private final MediaQueueItem zzaqv;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzaqv = new MediaQueueItem(mediaInfo, null);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzaqv = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzaqv = new MediaQueueItem(mediaQueueItem, null);
        }

        public Builder clearItemId() {
            this.zzaqv.zzV(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzaqv.zzU(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzaqv.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzaqv.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzaqv.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzaqv.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqv.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzaqv.zznj();
            return this.zzaqv;
        }
    }
}

