/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.internal.zzazf;
import java.util.Collection;
import java.util.Locale;

public final class CastMediaControlIntent {
    public static final String DEFAULT_MEDIA_RECEIVER_APPLICATION_ID = "CC1AD845";
    public static final String ACTION_SYNC_STATUS = "com.google.android.gms.cast.ACTION_SYNC_STATUS";
    public static final String EXTRA_CUSTOM_DATA = "com.google.android.gms.cast.EXTRA_CUSTOM_DATA";
    public static final String EXTRA_CAST_APPLICATION_ID = "com.google.android.gms.cast.EXTRA_CAST_APPLICATION_ID";
    public static final String EXTRA_CAST_RELAUNCH_APPLICATION = "com.google.android.gms.cast.EXTRA_CAST_RELAUNCH_APPLICATION";
    public static final String EXTRA_CAST_LANGUAGE_CODE = "com.google.android.gms.cast.EXTRA_CAST_LANGUAGE_CODE";
    public static final String EXTRA_CAST_STOP_APPLICATION_WHEN_SESSION_ENDS = "com.google.android.gms.cast.EXTRA_CAST_STOP_APPLICATION_WHEN_SESSION_ENDS";
    public static final String EXTRA_DEBUG_LOGGING_ENABLED = "com.google.android.gms.cast.EXTRA_DEBUG_LOGGING_ENABLED";
    public static final String EXTRA_ERROR_CODE = "com.google.android.gms.cast.EXTRA_ERROR_CODE";
    public static final int ERROR_CODE_REQUEST_FAILED = 1;
    public static final int ERROR_CODE_SESSION_START_FAILED = 2;
    public static final int ERROR_CODE_TEMPORARILY_DISCONNECTED = 3;

    public static String categoryForRemotePlayback(String string) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("applicationId cannot be null or empty");
        }
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST_REMOTE_PLAYBACK", string, null);
    }

    public static String categoryForRemotePlayback() {
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST_REMOTE_PLAYBACK", null, null);
    }

    public static String categoryForCast(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("applicationId cannot be null");
        }
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST", string, null);
    }

    public static String categoryForCast(Collection<String> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("namespaces cannot be null");
        }
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST", null, collection);
    }

    public static String categoryForCast(String string, Collection<String> collection) {
        if (string == null) {
            throw new IllegalArgumentException("applicationId cannot be null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("namespaces cannot be null");
        }
        return CastMediaControlIntent.zza("com.google.android.gms.cast.CATEGORY_CAST", string, collection);
    }

    private static String zza(String string, String string2, Collection<String> collection) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string2 != null) {
            String string3 = string2.toUpperCase();
            if (!string3.matches("[A-F0-9]+")) {
                String string4 = String.valueOf(string2);
                throw new IllegalArgumentException(string4.length() != 0 ? "Invalid application ID: ".concat(string4) : new String("Invalid application ID: "));
            }
            stringBuilder.append("/").append(string3);
        }
        if (collection != null) {
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Must specify at least one namespace");
            }
            if (string2 == null) {
                stringBuilder.append("/");
            }
            stringBuilder.append("/");
            boolean bl = true;
            for (String string5 : collection) {
                zzazf.zzfg(string5);
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(zzazf.zzfi(string5));
            }
        }
        return stringBuilder.toString();
    }

    public static String languageTagForLocale(Locale locale) {
        return zzazf.zzb(locale);
    }

    private CastMediaControlIntent() {
    }
}

