/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzaf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzazw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zzelb = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzelc;
    public static final Parcelable.Creator<MediaMetadata> CREATOR;
    private final List<WebImage> zzbrr;
    private Bundle zzeld;
    private int zzele;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    MediaMetadata(List<WebImage> list, Bundle bundle, int n) {
        this.zzbrr = list;
        this.zzeld = bundle;
        this.zzele = n;
    }

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int n) {
        this(new ArrayList<WebImage>(), new Bundle(), n);
    }

    public int getMediaType() {
        return this.zzele;
    }

    public void clear() {
        this.zzeld.clear();
        this.zzbrr.clear();
    }

    public boolean containsKey(String string2) {
        return this.zzeld.containsKey(string2);
    }

    public Set<String> keySet() {
        return this.zzeld.keySet();
    }

    public void putString(String string2, String string3) {
        MediaMetadata.zzf(string2, 1);
        this.zzeld.putString(string2, string3);
    }

    public String getString(String string2) {
        MediaMetadata.zzf(string2, 1);
        return this.zzeld.getString(string2);
    }

    public void putInt(String string2, int n) {
        MediaMetadata.zzf(string2, 2);
        this.zzeld.putInt(string2, n);
    }

    public int getInt(String string2) {
        MediaMetadata.zzf(string2, 2);
        return this.zzeld.getInt(string2);
    }

    public void putDouble(String string2, double d) {
        MediaMetadata.zzf(string2, 3);
        this.zzeld.putDouble(string2, d);
    }

    public double getDouble(String string2) {
        MediaMetadata.zzf(string2, 3);
        return this.zzeld.getDouble(string2);
    }

    public void putDate(String string2, Calendar calendar) {
        MediaMetadata.zzf(string2, 4);
        this.zzeld.putString(string2, zzazw.zza(calendar));
    }

    public Calendar getDate(String string2) {
        MediaMetadata.zzf(string2, 4);
        String string3 = this.zzeld.getString(string2);
        if (string3 != null) {
            return zzazw.zzfm(string3);
        }
        return null;
    }

    public String getDateAsString(String string2) {
        MediaMetadata.zzf(string2, 4);
        return this.zzeld.getString(string2);
    }

    private static void zzf(String string2, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzelc.zzey(string2);
        if (n2 != n && n2 != 0) {
            String string3 = zzelb[n];
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Value for ").append(string2).append(" must be a ").append(string3).toString());
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zzele);
        }
        catch (JSONException jSONException) {}
        zzazw.zza(jSONObject, this.zzbrr);
        switch (this.zzele) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public final void zzl(JSONObject jSONObject) {
        this.clear();
        this.zzele = 0;
        try {
            this.zzele = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {}
        zzazw.zza(this.zzbrr, jSONObject);
        switch (this.zzele) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                return;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                return;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                return;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                return;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                return;
            }
        }
        this.zzb(jSONObject, new String[0]);
    }

    private final void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            block7: for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                if (!this.zzeld.containsKey(string2)) continue;
                switch (zzelc.zzey(string2)) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzelc.zzew(string2), (Object)this.zzeld.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzelc.zzew(string2), this.zzeld.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzelc.zzew(string2), this.zzeld.getDouble(string2));
                    }
                }
            }
            for (String string3 : this.zzeld.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.zzeld.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    private final void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = zzelc.zzex(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (zzelc.zzey(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzeld.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String) || zzazw.zzfm((String)object) == null) break;
                                this.zzeld.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzeld.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzeld.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.zzeld.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzeld.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzeld.putDouble(string2, ((Double)object).doubleValue());
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)((Object)object);
        return this.zzb(this.zzeld, mediaMetadata.zzeld) && this.zzbrr.equals(mediaMetadata.zzbrr);
    }

    public int hashCode() {
        int n = 17;
        for (String string2 : this.zzeld.keySet()) {
            n = n * 31 + this.zzeld.get(string2).hashCode();
        }
        return n * 31 + this.zzbrr.hashCode();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MediaMetadata mediaMetadata = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, mediaMetadata.getImages(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Bundle)mediaMetadata.zzeld, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, (int)mediaMetadata.getMediaType());
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public List<WebImage> getImages() {
        return this.zzbrr;
    }

    public boolean hasImages() {
        return this.zzbrr != null && !this.zzbrr.isEmpty();
    }

    public void clearImages() {
        this.zzbrr.clear();
    }

    public void addImage(WebImage webImage) {
        this.zzbrr.add(webImage);
    }

    private final boolean zzb(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zzb((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    static {
        CREATOR = new zzaf();
        zzelc = new zza().zzb(KEY_CREATION_DATE, "creationDateTime", 4).zzb(KEY_RELEASE_DATE, "releaseDate", 4).zzb(KEY_BROADCAST_DATE, "originalAirdate", 4).zzb(KEY_TITLE, "title", 1).zzb(KEY_SUBTITLE, "subtitle", 1).zzb(KEY_ARTIST, "artist", 1).zzb(KEY_ALBUM_ARTIST, "albumArtist", 1).zzb(KEY_ALBUM_TITLE, "albumName", 1).zzb(KEY_COMPOSER, "composer", 1).zzb(KEY_DISC_NUMBER, "discNumber", 2).zzb(KEY_TRACK_NUMBER, "trackNumber", 2).zzb(KEY_SEASON_NUMBER, "season", 2).zzb(KEY_EPISODE_NUMBER, "episode", 2).zzb(KEY_SERIES_TITLE, "seriesTitle", 1).zzb(KEY_STUDIO, "studio", 1).zzb(KEY_WIDTH, "width", 2).zzb(KEY_HEIGHT, "height", 2).zzb(KEY_LOCATION_NAME, "location", 1).zzb(KEY_LOCATION_LATITUDE, "latitude", 3).zzb(KEY_LOCATION_LONGITUDE, "longitude", 3);
    }

    static final class zza {
        private final Map<String, String> zzelf = new HashMap<String, String>();
        private final Map<String, String> zzelg = new HashMap<String, String>();
        private final Map<String, Integer> zzelh = new HashMap<String, Integer>();

        public final zza zzb(String string2, String string3, int n) {
            this.zzelf.put(string2, string3);
            this.zzelg.put(string3, string2);
            this.zzelh.put(string2, n);
            return this;
        }

        public final String zzew(String string2) {
            return this.zzelf.get(string2);
        }

        public final String zzex(String string2) {
            return this.zzelg.get(string2);
        }

        public final int zzey(String string2) {
            Integer n = this.zzelh.get(string2);
            if (n != null) {
                return n;
            }
            return 0;
        }
    }
}

