/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzazf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaStatus
extends zza {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzai();
    private MediaInfo zzela;
    private long zzelq;
    private int zzelr;
    private double zzels;
    private int zzelt;
    private int zzelu;
    private long zzelv;
    private long zzelw;
    private double zzelx;
    private boolean zzely;
    private long[] zzelo;
    private int zzelz;
    private int zzema;
    private String zzehm;
    private JSONObject zzehn;
    private int zzemb;
    private ArrayList<MediaQueueItem> zzemc = new ArrayList();
    private boolean zzemd;
    private AdBreakStatus zzeme;
    private VideoInfo zzemf;
    private final SparseArray<Integer> zzemg = new SparseArray();

    MediaStatus(MediaInfo mediaInfo, long l, int n, double d, int n2, int n3, long l2, long l3, double d2, boolean bl, long[] lArray, int n4, int n5, String string2, int n6, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.zzela = mediaInfo;
        this.zzelq = l;
        this.zzelr = n;
        this.zzels = d;
        this.zzelt = n2;
        this.zzelu = n3;
        this.zzelv = l2;
        this.zzelw = l3;
        this.zzelx = d2;
        this.zzely = bl;
        this.zzelo = lArray;
        this.zzelz = n4;
        this.zzema = n5;
        this.zzehm = string2;
        if (this.zzehm != null) {
            try {
                this.zzehn = new JSONObject(this.zzehm);
            }
            catch (JSONException jSONException) {
                this.zzehn = null;
                this.zzehm = null;
            }
        } else {
            this.zzehn = null;
        }
        this.zzemb = n6;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzemd = bl2;
        this.zzeme = adBreakStatus;
        this.zzemf = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    public final long zzabp() {
        return this.zzelq;
    }

    public int getPlayerState() {
        return this.zzelt;
    }

    public int getIdleReason() {
        return this.zzelu;
    }

    public double getPlaybackRate() {
        return this.zzels;
    }

    public MediaInfo getMediaInfo() {
        return this.zzela;
    }

    public long getStreamPosition() {
        return this.zzelv;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzelw & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzelx;
    }

    public boolean isMute() {
        return this.zzely;
    }

    public long[] getActiveTrackIds() {
        return this.zzelo;
    }

    public JSONObject getCustomData() {
        return this.zzehn;
    }

    public int getCurrentItemId() {
        return this.zzelr;
    }

    public int getLoadingItemId() {
        return this.zzelz;
    }

    public int getPreloadedItemId() {
        return this.zzema;
    }

    public int getQueueRepeatMode() {
        return this.zzemb;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzemc;
    }

    public int getQueueItemCount() {
        return this.zzemc.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzemd;
    }

    public final void zzaw(boolean bl) {
        this.zzemd = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzeme;
    }

    public VideoInfo getVideoInfo() {
        return this.zzemf;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        block75: {
            int n3;
            block73: {
                MediaQueueItem[] mediaQueueItemArray;
                int n4;
                JSONArray jSONArray;
                String string2;
                MediaStatus mediaStatus;
                block74: {
                    block72: {
                        int n5;
                        boolean bl;
                        int n6;
                        block71: {
                            int n7;
                            block70: {
                                int n8;
                                int n9;
                                int n10;
                                int n11;
                                long[] lArray;
                                boolean bl2;
                                block69: {
                                    block67: {
                                        int n12;
                                        block68: {
                                            block65: {
                                                block66: {
                                                    long l;
                                                    long l2;
                                                    double d;
                                                    n2 = 0;
                                                    long l3 = jSONObject.getLong("mediaSessionId");
                                                    if (l3 != this.zzelq) {
                                                        this.zzelq = l3;
                                                        n2 = 1;
                                                    }
                                                    if (jSONObject.has("playerState")) {
                                                        int n13 = 0;
                                                        String string3 = jSONObject.getString("playerState");
                                                        if (string3.equals("IDLE")) {
                                                            n13 = 1;
                                                        } else if (string3.equals("PLAYING")) {
                                                            n13 = 2;
                                                        } else if (string3.equals("PAUSED")) {
                                                            n13 = 3;
                                                        } else if (string3.equals("BUFFERING")) {
                                                            n13 = 4;
                                                        }
                                                        if (n13 != this.zzelt) {
                                                            this.zzelt = n13;
                                                            n2 |= 2;
                                                        }
                                                        if (n13 == 1 && jSONObject.has("idleReason")) {
                                                            int n14 = 0;
                                                            string3 = jSONObject.getString("idleReason");
                                                            if (string3.equals("CANCELLED")) {
                                                                n14 = 2;
                                                            } else if (string3.equals("INTERRUPTED")) {
                                                                n14 = 3;
                                                            } else if (string3.equals("FINISHED")) {
                                                                n14 = 1;
                                                            } else if (string3.equals("ERROR")) {
                                                                n14 = 4;
                                                            }
                                                            if (n14 != this.zzelu) {
                                                                this.zzelu = n14;
                                                                n2 |= 2;
                                                            }
                                                        }
                                                    }
                                                    if (jSONObject.has("playbackRate") && this.zzels != (d = jSONObject.getDouble("playbackRate"))) {
                                                        this.zzels = d;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = (long)(jSONObject.getDouble("currentTime") * 1000.0)) != this.zzelv) {
                                                        this.zzelv = l2;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzelw) {
                                                        this.zzelw = l;
                                                        n2 |= 2;
                                                    }
                                                    if (jSONObject.has("volume") && (n & 1) == 0) {
                                                        JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
                                                        double d2 = jSONObject2.getDouble("level");
                                                        if (d2 != this.zzelx) {
                                                            this.zzelx = d2;
                                                            n2 |= 2;
                                                        }
                                                        boolean bl3 = jSONObject2.getBoolean("muted");
                                                        n12 = bl3 ? 1 : 0;
                                                        if (bl3 != this.zzely) {
                                                            this.zzely = n12;
                                                            n2 |= 2;
                                                        }
                                                    }
                                                    bl2 = false;
                                                    lArray = null;
                                                    if (!jSONObject.has("activeTrackIds")) break block65;
                                                    JSONArray jSONArray2 = jSONObject.getJSONArray("activeTrackIds");
                                                    n12 = jSONArray2.length();
                                                    lArray = new long[n12];
                                                    for (n11 = 0; n11 < n12; ++n11) {
                                                        lArray[n11] = jSONArray2.getLong(n11);
                                                    }
                                                    if (this.zzelo != null) break block66;
                                                    bl2 = true;
                                                    break block67;
                                                }
                                                if (this.zzelo.length == n12) break block68;
                                                bl2 = true;
                                                break block67;
                                            }
                                            if (this.zzelo != null) {
                                                bl2 = true;
                                            }
                                            break block69;
                                        }
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            if (this.zzelo[n11] == lArray[n11]) continue;
                                            bl2 = true;
                                            break;
                                        }
                                    }
                                    if (bl2) {
                                        this.zzelo = lArray;
                                    }
                                }
                                if (bl2) {
                                    this.zzelo = lArray;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("customData")) {
                                    this.zzehn = jSONObject.getJSONObject("customData");
                                    this.zzehm = null;
                                    n2 |= 2;
                                }
                                if (jSONObject.has("media")) {
                                    JSONObject jSONObject3 = jSONObject.getJSONObject("media");
                                    MediaInfo mediaInfo = new MediaInfo(jSONObject3);
                                    if (this.zzela == null || this.zzela != null && !this.zzela.equals((Object)mediaInfo)) {
                                        this.zzela = mediaInfo;
                                        n2 |= 2;
                                    }
                                    if (jSONObject3.has("metadata")) {
                                        n2 |= 4;
                                    }
                                }
                                if (jSONObject.has("currentItemId") && this.zzelr != (n10 = jSONObject.getInt("currentItemId"))) {
                                    this.zzelr = n10;
                                    n2 |= 2;
                                }
                                if (this.zzema != (n9 = jSONObject.optInt("preloadedItemId", 0))) {
                                    this.zzema = n9;
                                    n2 |= 0x10;
                                }
                                if (this.zzelz != (n8 = jSONObject.optInt("loadingItemId", 0))) {
                                    this.zzelz = n8;
                                    n2 |= 2;
                                }
                                n6 = n11 = this.zzela == null ? -1 : this.zzela.getStreamType();
                                n3 = this.zzelz;
                                n7 = this.zzelu;
                                if (this.zzelt == 1) break block70;
                                bl = false;
                                break block71;
                            }
                            switch (n7) {
                                case 1: 
                                case 3: {
                                    if (n3 == 0) break;
                                    bl = false;
                                    break block71;
                                }
                                case 2: {
                                    if (n6 != 2) break;
                                    bl = false;
                                    break block71;
                                }
                            }
                            bl = true;
                        }
                        if (bl) break block72;
                        JSONObject jSONObject4 = jSONObject;
                        mediaStatus = this;
                        n3 = 0;
                        if (jSONObject4.has("repeatMode")) {
                            n6 = mediaStatus.zzemb;
                            string2 = jSONObject4.getString("repeatMode");
                            n5 = -1;
                            switch (string2.hashCode()) {
                                case 1645952171: {
                                    if (!string2.equals("REPEAT_OFF")) break;
                                    n5 = 0;
                                    break;
                                }
                                case 1645938909: {
                                    if (!string2.equals("REPEAT_ALL")) break;
                                    n5 = 1;
                                    break;
                                }
                                case -962896020: {
                                    if (!string2.equals("REPEAT_SINGLE")) break;
                                    n5 = 2;
                                    break;
                                }
                                case -1118317585: {
                                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                                    n5 = 3;
                                    break;
                                }
                            }
                            switch (n5) {
                                case 0: {
                                    n6 = 0;
                                    break;
                                }
                                case 1: {
                                    n6 = 1;
                                    break;
                                }
                                case 2: {
                                    n6 = 2;
                                    break;
                                }
                                case 3: {
                                    n6 = 3;
                                    break;
                                }
                            }
                            if (mediaStatus.zzemb != n6) {
                                mediaStatus.zzemb = n6;
                                n3 = 1;
                            }
                        }
                        if (!jSONObject4.has("items")) break block73;
                        jSONArray = jSONObject4.getJSONArray("items");
                        n4 = jSONArray.length();
                        string2 = new SparseArray();
                        for (n5 = 0; n5 < n4; ++n5) {
                            string2.put(n5, (Object)jSONArray.getJSONObject(n5).getInt("itemId"));
                        }
                        mediaQueueItemArray = new MediaQueueItem[n4];
                        break block74;
                    }
                    this.zzelr = 0;
                    this.zzelz = 0;
                    this.zzema = 0;
                    if (!this.zzemc.isEmpty()) {
                        MediaStatus mediaStatus2 = this;
                        this.zzemb = 0;
                        mediaStatus2.zzemc.clear();
                        mediaStatus2.zzemg.clear();
                        n2 |= 8;
                    }
                    break block75;
                }
                for (int i = 0; i < n4; ++i) {
                    Integer n15 = (Integer)string2.get(i);
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = mediaStatus.getItemById(n15);
                    if (mediaQueueItem != null) {
                        n3 |= mediaQueueItem.zzm(jSONObject5);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == mediaStatus.getIndexById(n15)) continue;
                        n3 = 1;
                        continue;
                    }
                    n3 = 1;
                    if (n15 == mediaStatus.zzelr) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(mediaStatus.zzela).build();
                        mediaQueueItemArray[i].zzm(jSONObject5);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject5);
                }
                if (mediaStatus.zzemc.size() != n4) {
                    n3 = 1;
                }
                mediaStatus.zza(mediaQueueItemArray);
            }
            if (n3 != 0) {
                n2 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzj(jSONObject.optJSONObject("breakStatus"));
        if (this.zzeme == null && adBreakStatus != null || this.zzeme != null && !this.zzeme.equals((Object)adBreakStatus)) {
            boolean bl = adBreakStatus != null;
            this.zzemd = bl;
            this.zzeme = adBreakStatus;
            n2 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzn(jSONObject.optJSONObject("videoInfo"));
        if (this.zzemf == null && videoInfo != null || this.zzemf != null && !this.zzemf.equals((Object)videoInfo)) {
            this.zzemf = videoInfo;
            n2 |= 0x40;
        }
        if (jSONObject.has("breakInfo") && this.zzela != null) {
            this.zzela.zzk(jSONObject.getJSONObject("breakInfo"));
            n2 |= 2;
        }
        return n2;
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzemg.get(n);
        if (n2 == null) {
            return null;
        }
        return this.zzemc.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzemc.size()) {
            return null;
        }
        return this.zzemc.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzemg.get(n);
    }

    private final void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzemc.clear();
        this.zzemg.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzemc.add(mediaQueueItem);
            this.zzemg.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzehn == null != (mediaStatus.zzehn == null)) {
            return false;
        }
        if (this.zzelq == mediaStatus.zzelq && this.zzelr == mediaStatus.zzelr && this.zzels == mediaStatus.zzels && this.zzelt == mediaStatus.zzelt && this.zzelu == mediaStatus.zzelu && this.zzelv == mediaStatus.zzelv && this.zzelx == mediaStatus.zzelx && this.zzely == mediaStatus.zzely && this.zzelz == mediaStatus.zzelz && this.zzema == mediaStatus.zzema && this.zzemb == mediaStatus.zzemb && Arrays.equals(this.zzelo, mediaStatus.zzelo) && zzazf.zza(this.zzelw, mediaStatus.zzelw) && zzazf.zza(this.zzemc, mediaStatus.zzemc) && zzazf.zza(this.zzela, mediaStatus.zzela)) {
            MediaStatus mediaStatus2 = mediaStatus;
            MediaStatus mediaStatus3 = this;
            if ((mediaStatus3.zzehn == null || mediaStatus2.zzehn == null || zzn.zzc((Object)mediaStatus3.zzehn, (Object)mediaStatus2.zzehn)) && this.zzemd == mediaStatus.isPlayingAd()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzela, this.zzelq, this.zzelr, this.zzels, this.zzelt, this.zzelu, this.zzelv, this.zzelw, this.zzelx, this.zzely, Arrays.hashCode(this.zzelo), this.zzelz, this.zzema, String.valueOf(this.zzehn), this.zzemb, this.zzemc, this.zzemd});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzehm = this.zzehn == null ? null : this.zzehn.toString();
        Parcel parcel2 = parcel;
        MediaStatus mediaStatus = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Parcelable)mediaStatus.getMediaInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (long)mediaStatus.zzelq);
        zzd.zzc((Parcel)parcel2, (int)4, (int)mediaStatus.getCurrentItemId());
        zzd.zza((Parcel)parcel2, (int)5, (double)mediaStatus.getPlaybackRate());
        zzd.zzc((Parcel)parcel2, (int)6, (int)mediaStatus.getPlayerState());
        zzd.zzc((Parcel)parcel2, (int)7, (int)mediaStatus.getIdleReason());
        zzd.zza((Parcel)parcel2, (int)8, (long)mediaStatus.getStreamPosition());
        zzd.zza((Parcel)parcel2, (int)9, (long)mediaStatus.zzelw);
        zzd.zza((Parcel)parcel2, (int)10, (double)mediaStatus.getStreamVolume());
        zzd.zza((Parcel)parcel2, (int)11, (boolean)mediaStatus.isMute());
        zzd.zza((Parcel)parcel2, (int)12, (long[])mediaStatus.getActiveTrackIds(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)mediaStatus.getLoadingItemId());
        zzd.zzc((Parcel)parcel2, (int)14, (int)mediaStatus.getPreloadedItemId());
        zzd.zza((Parcel)parcel2, (int)15, (String)mediaStatus.zzehm, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)16, (int)mediaStatus.zzemb);
        zzd.zzc((Parcel)parcel2, (int)17, mediaStatus.zzemc, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)mediaStatus.isPlayingAd());
        zzd.zza((Parcel)parcel2, (int)19, (Parcelable)mediaStatus.getAdBreakStatus(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)20, (Parcelable)mediaStatus.getVideoInfo(), (int)n, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzeme == null || this.zzela == null) {
            return null;
        }
        String string2 = this.zzeme.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzela.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzeme == null || this.zzela == null) {
            return null;
        }
        String string2 = this.zzeme.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzela.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

