/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzn;
import com.google.android.gms.internal.zzazf;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zza
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzaj();
    private long zzdxf;
    private int zzeda;
    private String zzekr;
    private String zzekt;
    private String mName;
    private String zzdms;
    private int zzemh;
    private String zzehm;
    private JSONObject zzehn;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzdxf = l;
        this.zzeda = n;
        this.zzekr = string2;
        this.zzekt = string3;
        this.mName = string4;
        this.zzdms = string5;
        this.zzemh = n2;
        this.zzehm = string6;
        if (this.zzehm != null) {
            try {
                this.zzehn = new JSONObject(this.zzehm);
                return;
            }
            catch (JSONException jSONException) {
                this.zzehn = null;
                this.zzehm = null;
                return;
            }
        }
        this.zzehn = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zzdxf = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzeda = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzeda = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzeda = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzekr = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzekt = jSONObject2.optString("trackContentType", null);
                            mediaTrack.mName = jSONObject2.optString("name", null);
                            mediaTrack.zzdms = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzemh = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzemh = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzemh = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzemh = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzemh = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzemh = 0;
        }
        mediaTrack.zzehn = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzdxf = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzeda = n;
    }

    public final long getId() {
        return this.zzdxf;
    }

    public final int getType() {
        return this.zzeda;
    }

    public final String getContentId() {
        return this.zzekr;
    }

    public final void setContentId(String string2) {
        this.zzekr = string2;
    }

    public final String getContentType() {
        return this.zzekt;
    }

    public final void setContentType(String string2) {
        this.zzekt = string2;
    }

    public final String getName() {
        return this.mName;
    }

    final void setName(String string2) {
        this.mName = string2;
    }

    public final String getLanguage() {
        return this.zzdms;
    }

    final void setLanguage(String string2) {
        this.zzdms = string2;
    }

    public final int getSubtype() {
        return this.zzemh;
    }

    final void zzba(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzeda != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzemh = n;
    }

    public final JSONObject getCustomData() {
        return this.zzehn;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzehn = jSONObject;
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzdxf);
            switch (this.zzeda) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzekr != null) {
                jSONObject.put("trackContentId", (Object)this.zzekr);
            }
            if (this.zzekt != null) {
                jSONObject.put("trackContentType", (Object)this.zzekt);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdms)) {
                jSONObject.put("language", (Object)this.zzdms);
            }
            switch (this.zzemh) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzehn != null) {
                jSONObject.put("customData", (Object)this.zzehn);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzehn == null != (mediaTrack.zzehn == null)) {
            return false;
        }
        if (this.zzehn != null && mediaTrack.zzehn != null && !zzn.zzc((Object)this.zzehn, (Object)mediaTrack.zzehn)) {
            return false;
        }
        return this.zzdxf == mediaTrack.zzdxf && this.zzeda == mediaTrack.zzeda && zzazf.zza(this.zzekr, mediaTrack.zzekr) && zzazf.zza(this.zzekt, mediaTrack.zzekt) && zzazf.zza(this.mName, mediaTrack.mName) && zzazf.zza(this.zzdms, mediaTrack.zzdms) && this.zzemh == mediaTrack.zzemh;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdxf, this.zzeda, this.zzekr, this.zzekt, this.mName, this.zzdms, this.zzemh, String.valueOf(this.zzehn)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzehm = this.zzehn == null ? null : this.zzehn.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzehm, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zzemi;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzemi = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzemi.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzemi.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzemi.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzemi.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzemi.setLanguage(zzazf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzemi.zzba(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzemi.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzemi;
        }
    }
}

