/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzaya;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayd;
import com.google.android.gms.internal.zzaye;
import com.google.android.gms.internal.zzaym;
import com.google.android.gms.internal.zzayn;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayq;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazp;
import com.google.android.gms.internal.zzazu;
import com.google.android.gms.internal.zzazv;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaxz
extends zzayu {
    private static String NAMESPACE = zzazf.zzfh("com.google.cast.games");
    private static final zzazp zzejl = new zzazp("GameManagerChannel");
    private final Map<String, String> zzeyu = new ConcurrentHashMap<String, String>();
    private final List<zzazv> zzeyv;
    private final SharedPreferences zzbfr;
    private final String zzeyw;
    private final Cast.CastApi zzeow;
    private final GoogleApiClient zzetx;
    private zzaym zzeyx;
    private boolean zzeyy = false;
    private GameManagerState zzeyz;
    private GameManagerState zzeza;
    private String zzezb;
    private JSONObject zzezc;
    private long zzezd = 0L;
    private GameManagerClient.Listener zzeze;
    private final zzd zzasl;
    private String zzezf;

    public zzaxz(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzasl = zzh.zzalc();
        this.zzeyv = new ArrayList<zzazv>();
        this.zzeyw = string2;
        this.zzeow = castApi;
        this.zzetx = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzbfr = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzeza = null;
        this.zzeyz = new zzayo(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzetx.zze((zzm)new zzaya(this, gameManagerClient));
    }

    public final synchronized void dispose() throws IllegalStateException {
        if (this.zzeyy) {
            return;
        }
        this.zzeyz = null;
        this.zzeza = null;
        this.zzezb = null;
        this.zzezc = null;
        this.zzeyy = true;
        try {
            this.zzeow.removeMessageReceivedCallbacks(this.zzetx, this.getNamespace());
            return;
        }
        catch (IOException iOException) {
            zzejl.zzf("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzadx();
        return this.zzetx.zze((zzm)new zzayc(this, n, string2, jSONObject));
    }

    public final synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzadx();
        long l = ++this.zzezd;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzeow.sendMessage(this.zzetx, this.getNamespace(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzadx();
        return this.zzetx.zze((zzm)new zzayd(this, string2, jSONObject));
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzadx();
        return this.zzeyz;
    }

    public final synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzadx();
        return this.zzezf;
    }

    private final synchronized String zzfe(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzeyu.get(string2);
    }

    public final synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzeze = listener;
    }

    @Override
    public final void zzff(String string2) {
        int n;
        zzayn zzayn2;
        zzejl.zzb("message received: %s", string2);
        try {
            zzayn2 = zzayn.zzo(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zzejl.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzayn2 == null) {
            zzejl.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzayn2.zzeyx == null || this.isDisposed()) {
            return;
        }
        boolean bl = zzayn2.zzezw == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzayn2.zzfae)) {
            this.zzeyu.put(zzayn2.zzezq, zzayn2.zzfae);
            this.zzady();
        }
        if (zzayn2.zzezx == 0) {
            this.zza(zzayn2);
        } else {
            zzejl.zzf("Not updating from game message because the message contains error code: %d", zzayn2.zzezx);
        }
        int n2 = zzayn2.zzezx;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zzejl.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zzb(zzayn2.zzezr, n, zzayn2);
        }
        if (this.isInitialized() && n == 0) {
            zzaxz zzaxz2 = this;
            if (zzaxz2.zzeze != null) {
                if (zzaxz2.zzeza != null && !zzaxz2.zzeyz.equals(zzaxz2.zzeza)) {
                    zzaxz2.zzeze.onStateChanged(zzaxz2.zzeyz, zzaxz2.zzeza);
                }
                if (zzaxz2.zzezc != null && zzaxz2.zzezb != null) {
                    zzaxz2.zzeze.onGameMessageReceived(zzaxz2.zzezb, zzaxz2.zzezc);
                }
            }
            zzaxz2.zzeza = null;
            zzaxz2.zzezb = null;
            zzaxz2.zzezc = null;
        }
    }

    public final synchronized boolean isDisposed() {
        return this.zzeyy;
    }

    private final synchronized boolean isInitialized() {
        return this.zzeyx != null;
    }

    @Override
    public final void zzc(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzazv.zzajk;
        synchronized (object) {
            Iterator<zzazv> iterator2 = this.zzeyv.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaes()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzadx() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzazu zzazu2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzezd, string2, n, jSONObject)) == null) {
            zzazu2.zza(-1L, 2001, null);
            zzejl.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzazv zzazv2 = new zzazv(this.zzasl, 30000L);
        zzazv2.zza(l, zzazu2);
        this.zzeyv.add(zzazv2);
        this.zzbb(true);
        this.zzeow.sendMessage(this.zzetx, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzaye(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzfe(string2));
        }
        catch (JSONException jSONException) {
            zzejl.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzayn zzayn2) {
        boolean bl = zzayn2.zzezw == 1;
        this.zzeza = this.zzeyz;
        if (bl && zzayn2.zzeyx != null) {
            this.zzeyx = zzayn2.zzeyx;
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzayq zzayq2 : zzayn2.zzfab) {
            String string2 = zzayq2.getPlayerId();
            zzayp zzayp2 = new zzayp(string2, zzayq2.getPlayerState(), zzayq2.getPlayerData(), this.zzeyu.containsKey(string2));
            arrayList.add(zzayp2);
        }
        this.zzeyz = new zzayo(zzayn2.zzfaa, zzayn2.zzezz, zzayn2.zzfad, zzayn2.zzfac, arrayList, this.zzeyx.zzaeb(), this.zzeyx.getMaxPlayers());
        PlayerInfo playerInfo = this.zzeyz.getPlayer(zzayn2.zzezq);
        if (playerInfo != null && playerInfo.isControllable() && zzayn2.zzezw == 2) {
            this.zzezb = zzayn2.zzezq;
            this.zzezc = zzayn2.zzezs;
        }
    }

    private final void zzb(long l, int n, Object object) {
        Iterator<zzazv> iterator = this.zzeyv.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzady() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzeyw);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzeyu));
            this.zzbfr.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zzejl.zzf("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzadz() {
        String string2 = this.zzbfr.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzeyw.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzeyu.put(string4, jSONObject2.getString(string4));
                }
                this.zzezd = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zzejl.zzf("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzaxz zzaxz2) {
        return zzaxz2.zzetx;
    }

    static /* synthetic */ Cast.CastApi zzb(zzaxz zzaxz2) {
        return zzaxz2.zzeow;
    }

    static /* synthetic */ void zzc(zzaxz zzaxz2) {
        zzaxz2.zzadz();
    }

    static /* synthetic */ void zzd(zzaxz zzaxz2) {
        zzaxz2.zzady();
    }

    static /* synthetic */ void zza(zzaxz zzaxz2, String string2, int n, JSONObject jSONObject, zzazu zzazu2) {
        zzaxz2.zza(string2, n, jSONObject, zzazu2);
    }

    static /* synthetic */ zzazp zzaea() {
        return zzejl;
    }

    static /* synthetic */ zzaym zza(zzaxz zzaxz2, zzaym zzaym2) {
        zzaxz2.zzeyx = null;
        return null;
    }

    static /* synthetic */ String zza(zzaxz zzaxz2, String string2) {
        zzaxz2.zzezf = string2;
        return zzaxz2.zzezf;
    }
}

